using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using System.IO;


namespace testEditor
{
	/// <summary>
	/// Summary description for variants.
	/// </summary>
	public class variants : System.Web.UI.Page
	{
		protected System.Web.UI.HtmlControls.HtmlGenericControl divVariantList;
		protected testEditor.webheader ucHeader;

		private void Page_Load(object sender, System.EventArgs e)
		{
			// Put user code to initialize the page here

			ucHeader.pageTitle = "Learning Object Editing Toolkit";

			
				if (Request["title"] != null)
				{
					string loId = Request["title"].ToString();
					getVariants(loId);
				}


		}



		private void getVariants(string loname)
		{
			string logfile = Request.PhysicalApplicationPath + "variants\\" + loname + "\\changes.log";

			if (!File.Exists(logfile))
			{
				return;
			}

			ArrayList variants = new ArrayList();

			StreamReader sreader = null;						
			try
			{	//get the last line of the file to retrive lastest version			
				sreader = new StreamReader(logfile);
				string line;
				while ( (line = sreader.ReadLine()) != null)
				{
					variants.Add(line);
				}
			}
			catch(IOException ex)
			{
				throw ex;
			}
			finally
			{				
				sreader.Close();
			}

			//start to generate a table of variant list
			divVariantList.InnerHtml = "<table border=\"0\" cellspacing=\"0\" cellpadding=\"5\" width=\"78%\">";
            char[] delim = new char[]{'\t'};

			//start from the current first (last line)
			for (int i=variants.Count-1; i>=0; i--)
			{
				string[] attrs = variants[i].ToString().Split(delim);

				string currVersion = "";
				if (i == variants.Count - 1)
				{
					currVersion = "(current version)";
				}
				else
				{
					currVersion = "";
				}

				//TODO: fill the content of link (href=)
				//convert to GB time format
				System.IFormatProvider format = new System.Globalization.CultureInfo("en-US", true);
				DateTime dt = DateTime.Parse(attrs[0], format);
		        //DateTime dt = DateTime.Parse("1/25/2007 5:09 PM", format);

				//string dtstr = dt.ToLocalTime().ToShortDateString() + " " + dt.ToShortTimeString();
				string dtstr = dt.Day.ToString()+ "/" + dt.Month.ToString() + "/" + dt.Year.ToString() + " " + dt.ToShortTimeString();


				divVariantList.InnerHtml += "<tr><td>" + dtstr + "</td><td><a href=\"LOedit.aspx?title=" + attrs[1] + "&action=view&var=" + attrs[2] + "\">" + attrs[1] + "</a></td><td>" + attrs[3] + "</td><td>"; 
				if ( attrs[4].ToLower().Equals("noa"))
				{
					divVariantList.InnerHtml += "</td></tr>";
				}
				else
				{
					divVariantList.InnerHtml += attrs[4] + " changes " + currVersion + "</td></tr>";
 
				}

			}

			divVariantList.InnerHtml += "</table>";		
			
			
			
		}



		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{    
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion
	}
}
