using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Xml;
using System.Xml.Schema;
using System.IO;
using ICSharpCode.SharpZipLib.Zip;
using ICSharpCode.SharpZipLib.Checksums;

public partial class metaEdit : System.Web.UI.Page 
{
    
    Boolean deletingFlag = false;
    Boolean insertingFlag = false;
   // string[] delBans = new string[] { "title", "language", "description", "keyword", "centity", "rights.description" };
   // string currentLoDir = "";
  

    protected void Page_Load(object sender, EventArgs e)
    {

        LblErrMsg.Text = "";
        if (!IsPostBack)
        {

            //#########add new raltions
            addRelation("chu's file test", "IsBasedOn");
            //############


            if (Session["metasets"] != null)
            {
                Session["metasets"] = null;
            }
            int metaType = 0;
            string assetName = "";

            if (Request.QueryString["mtype"] != null)
            {
                metaType = Convert.ToInt32(Request.QueryString["mtype"]);
            }
            if (Request.QueryString["assetName"] != null)
            {
                assetName = Request.QueryString["assetName"].ToString();                 
            }

            string remotePath = "";
            if (Request.QueryString["fpath"] != null)
            {
                remotePath = Request.QueryString["fpath"].ToString();
                loadRemoteFile(remotePath);
            }

            if (Request.QueryString["filedir"] != null)
            {
                //global value to get the current directory name for lo
                Session["loDir"] = Request.QueryString["filedir"].ToString();
            }

            
            switch (metaType)
            {
                case 1:  //learning object metadata
                    //setdataFormTitle("test title");  how to do this?
                    BindGridView(1,null);
                    formtitle.InnerText = "Learning Object Metadata Editing";
                    break;
                case 2:   //asset metadata
                    BindGridView(2, assetName);
                    formtitle.InnerText = "Asset " + assetName + " Metadata Editing";
                    break;
                default:
                    goto case 1;
                    

            }
 
                        
        }

        

    }

    private void loadRemoteFile(string fpath)
    {
        string xmlLocalPath = Server.MapPath(@"App_Data\imsmanifest.xml");
        //fpath = "http://" + fpath;

        System.Net.WebClient remoteClient= new System.Net.WebClient();
        remoteClient.DownloadFile(fpath, xmlLocalPath);

    }


    private void setdataFormTitle(string title)
    {
        string titleScripts = "<script language='javascript'>" + "document.getElementById('" + "formtitle" + "').innerTEXT='" + title + "';</script>";
        LiteralJs.Text = titleScripts;
    }


    private void BindGridView(int mtype, string assetNm)
    {
        DataSet metaSets = Session["metasets"] as DataSet;
        if (metaSets == null)
        {
            metaSets = GetDataFromXml();
            Session["metasets"] = metaSets;
        }

        //populate the links for different sections of metadata
        populateLinks(metaSets,mtype,assetNm);

        DataTable sourceTbl = null;

        if (mtype == 1 || mtype == 0)  //lo or default case
        {
            sourceTbl = metaSets.Tables["lo"];
        }
        else if (mtype == 2)  //assets
        {
            if (assetNm != null)
            {
                sourceTbl = metaSets.Tables[assetNm];
            }
        }

        GridViewDS.DataSource = sourceTbl;
        GridViewDS.DataBind();
    }


    //make the links for lo and assets metadata
    private void populateLinks(DataSet ds, int mtype, string currAsset)
    {
        divLinks.InnerHtml = "<table cellpadding=\"2\" width=\"100%\"><tr>";

        //work out each portion a column should take
        int portion = (int)Math.Round((1 / (float)ds.Tables.Count * 100));
        
       
        foreach (DataTable dt in ds.Tables)
        {
            if (dt.TableName == "lo")
            {
                if (mtype == 1 || mtype == 0)
                {
                    divLinks.InnerHtml += "<td style=\"width:" + portion.ToString() + "%;background-color:Lavender;\"><a href=\"metaEdit.aspx?mtype=1\" style=\"background-color:#FFFFC0\">LO Metadata</a></td>";

                }
                else
                {
                    divLinks.InnerHtml += "<td style=\"width:" + portion.ToString() + "%;background-color:Lavender;\"><a href=\"metaEdit.aspx?mtype=1\">LO Metadata</a></td>";
                }
            }
            else
            {
                string assetNm = dt.TableName;
                if (mtype == 2 && assetNm == currAsset)
                {
                    divLinks.InnerHtml += "<td style=\"width:" + portion.ToString() + "%;background-color:Lavender; \"><a href=\"metaEdit.aspx?mtype=2&assetName=" + assetNm + "\" style=\"background-color:#FFFFC0\">Asset Metadata - " + assetNm + "</a></td>";

                }
                else
                {
                    divLinks.InnerHtml += "<td style=\"width:" + portion.ToString() + "%;background-color:Lavender;\"><a href=\"metaEdit.aspx?mtype=2&assetName=" + assetNm + "\">Asset Metadata - " + assetNm + "</a></td>";
                }
            }
        }

        divLinks.InnerHtml += "</tr></table>";

    }



    private DataSet GetDataFromXml()
    {
        string xmlpath = Server.MapPath(@"App_Data\imsmanifest.xml");

        // string schema1 = Server.MapPath(@"App_Data\imscp_v1p1.xsd");
        // string schema2 = Server.MapPath(@"App_Data\imsmd_v1p2p4_localised.xsd");

        XmlDataDocument xdd = new XmlDataDocument();

        try
        {
            xdd.Load(xmlpath);
        }
        catch (System.IO.FileNotFoundException e)
        {
            LblErrMsg.Text = "Cannot find the resouce file for metadata";
            LblErrMsg.ForeColor = System.Drawing.Color.Red;
        }

        //look for the namespace for imsmd: it would be under imsmd:lom for reload or other non-elang
        //LOs, but will be defined at root element with localised namspace in eLang LO
        XmlElement root = xdd.DocumentElement;
        string mdPrefix = root.GetNamespaceOfPrefix("imsmd");
        if (mdPrefix.Length == 0)
        {
            XmlNodeList lomNd = root.GetElementsByTagName("imsmd:lom");
            mdPrefix = lomNd[0].GetNamespaceOfPrefix("imsmd");
        }

        XmlNamespaceManager nsmanager = new XmlNamespaceManager(xdd.NameTable);

        /* have to declare a name even it is default namespace no prefix, can not 
         * use String.Empty as recommended somewhere. 
         * see http://msdn2.microsoft.com/en-us/library/d271ytdx.aspx
         * */
        nsmanager.AddNamespace("df", "http://www.imsglobal.org/xsd/imscp_v1p1");
        //nsmanager.AddNamespace("imsmd", "http://www.imsglobal.org/xsd/imsmd_v1p2");
        //to get the namespace dynamically
        nsmanager.AddNamespace("imsmd", mdPrefix);
        nsmanager.AddNamespace("l2o", "imsmd_v1p2_l2o_localised_Schema");

        DataSet metaDs = new DataSet();
        DataTable loTable = buildLOTable();

        //XmlElement root = xdd.DocumentElement;
        XmlNodeList metadataNodes = xdd.SelectNodes("descendant::df:metadata", nsmanager);

        bool hasReadLO = false; //determine if LO metadata has read or not, only one LO metadata 
        foreach (XmlNode metaNode in metadataNodes)
        {
            
            /* this is too restrict, as not all main html files called "index.html"
             * and it can be attached not only to resource tag*****
             * 
            if (metaNode.ParentNode.Name == "resource" && metaNode.ParentNode.Attributes["href"].Value.IndexOf("index.htm") >= 0)
             * 
             */
            if ((metaNode.ParentNode.Name == "resource" || metaNode.ParentNode.Name == "manifest" || metadataNodes.Count == 1) && hasReadLO == false)
            {
                fillMetaValueFromXml(metaNode, nsmanager, ref loTable);
              
                //add datatable into a session object
               // Session["loMetaData"] = loTable;

                metaDs.Tables.Add(loTable);
                hasReadLO = true;

            }
                //here could remove the first part of the condition, as it doesn't matter if it is true or not
            else if (metaNode.ParentNode.Name == "file" || hasReadLO == true)   //for resource metadata table creation
            {
                int stIdx = metaNode.ParentNode.Attributes["href"].Value.LastIndexOf("/");
                string fileName = metaNode.ParentNode.Attributes["href"].Value.Substring(stIdx + 1);
                DataTable assetTable = buildAssetTable(fileName);

                fillMetaValueFromXml(metaNode, nsmanager, ref assetTable);

                metaDs.Tables.Add(assetTable);
            }

        }

        return metaDs;

    }


    private void fillMetaValueFromXml(XmlNode metaNode, XmlNamespaceManager nsm, ref DataTable metaTable)
    {
        for (int i = 0; i < metaTable.Rows.Count; i++)
        {
               XmlNodeList currentNodes = metaNode.SelectNodes(metaTable.Rows[i]["xpathExp"].ToString(), nsm);
               if (currentNodes.Count > 1)
               {
                     string metadataValue = "";
                     for (int j = 0; j < currentNodes.Count - 1; j++)
                     {
                          metadataValue += currentNodes.Item(j).InnerText + "|";
                     }
                     //to avoid add the last "|"
                     metadataValue += currentNodes.Item(currentNodes.Count - 1).InnerText;
                    
                     metaTable.Rows[i]["metaVal"] = metadataValue;
                     
               }
               else if (currentNodes.Count == 1) //only one record
               {
                    metaTable.Rows[i]["metaVal"] = currentNodes.Item(0).InnerText;
                        
               }   
  

            /***************************************************
               //for the subValues. currently for asset table only
             **************************************************************/
              // if (metaTable.TableName == "lo")
               //    continue;

               if (metaTable.Rows[i]["subValueName"].ToString().Length > 0)
               {
                   XmlNodeList subValNodes = metaNode.SelectNodes(metaTable.Rows[i]["subValuePath"].ToString(), nsm);
                   if (subValNodes.Count > 1)
                   {
                       string subValue = "";
                       for (int j = 0; j < subValNodes.Count - 1; j++)
                       {
                           subValue += subValNodes.Item(j).InnerText + "|";
                       }
                       //to avoid add the last "|"
                       subValue += subValNodes.Item(subValNodes.Count - 1).InnerText;

                       metaTable.Rows[i]["subValueVal"] = subValue;

                   }
                   else if (subValNodes.Count == 1) //only one record
                   {
                       metaTable.Rows[i]["subValueVal"] = subValNodes.Item(0).InnerText;

                   }
               }
             

          }
        
    }


    private DataTable buildLOTable()
    {
        DataTable lometaTable = new DataTable("lo");

        //build tables
        DataColumn idCol = lometaTable.Columns.Add("metaId", typeof(Int32));
        idCol.AllowDBNull = false;
        idCol.Unique = true;
        //idCol.AutoIncrement = true;

        //can be ignored for now, test if the earler two lines are enough
        //lometaTable.PrimaryKey = new DataColumn[] { lometaTable.Columns["metaId"] };


        lometaTable.Columns.Add("lomCatNo", typeof(String));
        lometaTable.Columns.Add("lomName", typeof(String));
        lometaTable.Columns.Add("longName", typeof(String));
        lometaTable.Columns.Add("metaVal", typeof(String));
        lometaTable.Columns.Add("xpathExp", typeof(String));
        lometaTable.Columns.Add("description", typeof(String));
        lometaTable.Columns.Add("options", typeof(String));
        lometaTable.Columns.Add("canInsert", typeof(Boolean));
        lometaTable.Columns.Add("canDelete", typeof(Boolean));

        //######## add relation for automatic updating relation from wiki editor
        lometaTable.Columns.Add("subValueName", typeof(String));
        lometaTable.Columns.Add("subValueVal", typeof(String));
        lometaTable.Columns.Add("subValuePath", typeof(String));
        lometaTable.Columns.Add("subValueOption", typeof(String));
        //########

        //add the rows
        DataRow oRow = lometaTable.NewRow();
        oRow["metaId"] = 1;
        oRow["lomCatNo"] = "1.2";
        oRow["lomName"] = "title";
        oRow["longName"] = "Title of learning object";
        oRow["metaVal"] = "";
        oRow["xpathExp"] = "descendant::imsmd:title";
        oRow["description"] = "This is the only title or type field. This is not a description of the resource";
        oRow["options"] = "";
        oRow["canInsert"] = true;
        oRow["canDelete"] = false;

        //########## same as above
        oRow["subValueName"] = "";
        oRow["subValueVal"] = "";
        oRow["subValuePath"] = "";
        oRow["subValueOption"] = "";
        //#########

        lometaTable.Rows.Add(oRow);



        //or
        lometaTable.Rows.Add(new object[] { 2, "1.3", "language", "Educational Langauge", "", "descendant::imsmd:general/child::imsmd:language", "This is the native language of the resource", "British English|French|German|Italian", true, false, "", "", "", "" });
        lometaTable.Rows.Add(new object[] { 3, "1.4", "description", "Description", "", "descendant::imsmd:general/child::imsmd:description", "This should be a concise intensive description of the resource. There is a word limit of 50 words for this field", "", true, false, "", "", "", "" });
        lometaTable.Rows.Add(new object[] { 4, "1.5", "keyword", "Keywords", "", "descendant::imsmd:keyword", "This should be a maximum of 10 keywords that accurately  describe the resource", "", true, false, "", "", "", "" });

        lometaTable.Rows.Add(new object[] { 5, "1.6", "coverage", "Topic", "", "descendant::imsmd:coverage", "This should indicate the general coverage of the Learning Object (LO)", "", true, true, "", "", "", "" });
        lometaTable.Rows.Add(new object[] { 6, "2.3.x", "centity", "Author/Contributor", "", "descendant::imsmd:lifecycle/descendant::imsmd:centity", "This is the name of any authors/contributors and academic institutions", "", true, false, "", "", "", "" });
        lometaTable.Rows.Add(new object[] { 7, "5.2", "learningresourcetype", "Pedagogic type", "", "descendant::imsmd:educational/imsmd:learningresourcetype/imsmd:value", "Choose from: presentation-based/activity-based/case study-based/enquiry-based problem-based/collaboration-based, communication-based", "presentation-based|activity-based|case study-based|enquiry-based|problem-based|collaboration-based|communication-based", true, true, "", "", "", "" });
        lometaTable.Rows.Add(new object[] { 8, "5.9", "typicallearningtime", "Time needed to complete task", "", "descendant::imsmd:educational/descendant::imsmd:typicallearningtime", "This is the approx learning time, format: HH:MM:SS", "", true, true, "", "", "", "" });

        lometaTable.Rows.Add(new object[] { 9, "5.10", "edu.description", "Main task purpose", "", "descendant::imsmd:educational/child::imsmd:description", "This should outline the main purpose of the tasks involved within the LO", "", true, true, "", "", "", "" });
        lometaTable.Rows.Add(new object[] { 10, "5.15", "descriptionforlearner", "Description for learner", "", "descendant::l2o:l2o/l2o:descriptionforlearner", "e.g. main & subsidiary learning outcome(s), skill(s) being practised", "", true, true, "", "", "", "" });
        lometaTable.Rows.Add(new object[] { 11, "5.21", "tasklanguage", "Language of task instructions", "", "descendant::l2o:l2o/l2o:tasklanguage", "Please indicate the language the task instructions are presented in", "British English|French|German|Italian", true, true, "", "", "", "" });
        lometaTable.Rows.Add(new object[] { 12, "5.22", "subjectarea", "Subject or skill areas", "", "descendant::l2o:l2o/l2o:subjectarea", "Subject or skill areas", "", true, true, "", "", "", "" });

        lometaTable.Rows.Add(new object[] { 13, "6.3", "rights.description", "Copyright Holder", "", "descendant::imsmd:rights/child::imsmd:description", "Please consult your institutional IPR policy if you are unclear about this field", "", false, false, "", "", "", "" });
        lometaTable.Rows.Add(new object[] { 14, "9.1", "classification", "Level of task difficulty", "", "descendant::imsmd:classification/imsmd:purpose/imsmd:value", "Please choose Beginner, Intermediate, Advanced, Mastery", "Beginner|Intermediate|Advanced|Mastery", false, true, "", "", "", "" });
        lometaTable.Rows.Add(new object[] { 15, "9.1", "class.description", "Level(CEF,GCSE/A level, IELTS...)", "", "descendant::imsmd:classification/child::imsmd:description", "This should link to a national/international framework and level for material", "", false, true, "", "", "", "" });

        //###########
        lometaTable.Rows.Add(new object[] { 16, "7.2", "relation resource", "Name of related source(other LO, assets)", "", "descendant::imsmd:relation/imsmd:resource", "Specify the source related to the current LO", "", false, false, "Relation", "", "descendant::imsmd:relation/imsmd:kind/imsmd:value", "HasPart|IsBasedOn|Requires|IsVersionOf"});
       
        return lometaTable;

    }


    private DataTable buildAssetTable(string assetFile)
    {
        DataTable assetMetaTable = new DataTable(assetFile);

        //build tables
        DataColumn idCol = assetMetaTable.Columns.Add("metaId", typeof(Int32));
        idCol.AllowDBNull = false;
        idCol.Unique = true;
        //idCol.AutoIncrement = true;

        assetMetaTable.Columns.Add("lomCatNo", typeof(String));
        assetMetaTable.Columns.Add("lomName", typeof(String));
        assetMetaTable.Columns.Add("longName", typeof(String));
        assetMetaTable.Columns.Add("metaVal", typeof(String));
        assetMetaTable.Columns.Add("xpathExp", typeof(String));
        assetMetaTable.Columns.Add("description", typeof(String));
        assetMetaTable.Columns.Add("options", typeof(String));
        assetMetaTable.Columns.Add("canInsert", typeof(Boolean));
        assetMetaTable.Columns.Add("canDelete", typeof(Boolean));

        assetMetaTable.Columns.Add("subValueName", typeof(String));
        assetMetaTable.Columns.Add("subValueVal", typeof(String));
        assetMetaTable.Columns.Add("subValuePath", typeof(String));
        assetMetaTable.Columns.Add("subValueOption", typeof(String));

        //>>>>for inserting purpose when there is no current xml part available
        assetMetaTable.Columns.Add("insertPos", typeof(String));
        assetMetaTable.Columns.Add("xmlSnippet", typeof(String));


        //add the rows
        DataRow oRow = assetMetaTable.NewRow();
        oRow["metaId"] = 1;
        oRow["lomCatNo"] = "1.2";
        oRow["lomName"] = "title";
        oRow["longName"] = "Title or file name of resource";
        oRow["metaVal"] = "";
        oRow["xpathExp"] = "descendant::imsmd:title";
        oRow["description"] = "This is the only title or type field. This is not a description of the resource";
        oRow["options"] = "";
        oRow["canInsert"] = true;
        oRow["canDelete"] = false;

        oRow["subValueName"] = "";
        oRow["subValueVal"] = "";
        oRow["subValuePath"] = "";
        oRow["subValueOption"] = "";

        oRow["insertPos"] = "";
        oRow["xmlSnippet"] = "";

        assetMetaTable.Rows.Add(oRow);

        //or
        assetMetaTable.Rows.Add(new object[] { 2, "1.3", "language", "Native Langauge", "", "descendant::imsmd:general/child::imsmd:language", "This is the native language of the resource", "British English|French|German|Italian", true, false, "", "", "", "", "", "" });
        assetMetaTable.Rows.Add(new object[] { 3, "1.4", "description", "Description of resource", "", "descendant::imsmd:general/child::imsmd:description", "This should be a concise intensive description of the resource.", "", true, false, "", "", "", "", "", "" });
        assetMetaTable.Rows.Add(new object[] { 4, "1.5", "keyword", "Keywords", "", "descendant::imsmd:keyword", "This should be a maximum of 10 keywords that accurately  describe the resource", "", true, false, "", "", "", "", "", "" });

        assetMetaTable.Rows.Add(new object[] { 5, "2.3.x", "centity", "Author/Contributor", "", "descendant::imsmd:lifecycle/descendant::imsmd:centity", "This is the name of any authors/contributors and academic institutions", "", true, false, "", "", "", "", "", "" });
        assetMetaTable.Rows.Add(new object[] { 6, "4.1", "format", "File Type", "", "descendant::imsmd:technical/imsmd:format", "Where possible define the type of asset by type and extension type. If not known please leave this blank", "application/msword|application/pdf|image/jpeg", true, false, "", "", "", "", "", "" });
        assetMetaTable.Rows.Add(new object[] { 7, "4.7", "duration", "Duration (time dependant assets)", "", "descendant::imsmd:technical/imsmd:duration/imsmd:description", "If the resource is time relevant please put the length here in the follow format : HH:MM:SS", "", false, true, "", "", "", "", "descendant::imsmd:technical", "<imsmd:duration><imsmd:datetime /><imsmd:description><imsmd:langstring xml:lang=\"en\" /></imsmd:description></imsmd:duration>" });
        assetMetaTable.Rows.Add(new object[] { 8, "5.12.1", "language region", "Language specifics - Region", "", "descendant::l2o:l2o/l2o:languagespecifics/l2o:region", "This should be the native language of the content. Where possible please provide the details as indicated", "", true, true, "", "", "", "", "descendant::l2o:l2o/l2o:languagespecifics", "<l2o:region><langstring /></l2o:region>" });
        assetMetaTable.Rows.Add(new object[] { 9, "5.12.2", "language accent", "Language specifics - Accent/dialect", "", "descendant::l2o:l2o/l2o:languagespecifics/l2o:accent", "This should be the native language of the content. Where possible please provide the details as indicated", "", true, true, "", "", "", "", "descendant::l2o:l2o/l2o:languagespecifics", "<l2o:accent><langstring /></l2o:accent>" });
        assetMetaTable.Rows.Add(new object[] { 10, "5.12.3", "language register", "Language specifics - Register", "", "descendant::l2o:l2o/l2o:languagespecifics/l2o:register", "This should be the native language of the content. Where possible please provide the details as indicated", "", true, true, "", "", "", "", "descendant::l2o:l2o/l2o:languagespecifics", "<l2o:register><langstring /></l2o:register>" });
        assetMetaTable.Rows.Add(new object[] { 11, "5.13", "furtheruse", "Suggestion for further use", "", "descendant::l2o:l2o/l2o:furtheruse", "This is to describe in brief any activities the resource could aid", "", true, true, "", "", "", "", "descendant::l2o:l2o", "<l2o:furtheruse><langstring /></l2o:furtheruse>" });
        assetMetaTable.Rows.Add(new object[] { 12, "5.14", "informationforusers", "Information for users", "", "descendant::l2o:l2o/l2o:informationforusers", "This is used to describe any asset specific details for all user groups", "", true, true, "", "", "", "", "descendant::l2o:l2o", "<l2o:informationforusers><langstring /></l2o:informationforusers>" });
        assetMetaTable.Rows.Add(new object[] { 13, "5.16", "genre", "Presentational form or Genre", "", "descendant::l2o:l2o/l2o:genre", "For example, song, script, interview, flowchart", "", true, true, "", "", "", "", "descendant::l2o:l2o", "<l2o:genre><langstring /></l2o:genre>" });
        assetMetaTable.Rows.Add(new object[] { 14, "5.17", "language function", "Language functions", "", "descendant::l2o:l2o/l2o:languagefunction", "For example, purchasing goods, asking the way", "", true, true, "", "", "", "", "descendant::l2o:l2o", "<l2o:languagefunction><langstring /></l2o:languagefunction>" });
        //not defined in the asset template file, need to add!!!
        assetMetaTable.Rows.Add(new object[] { 15, "5.18", "language mode", "Discourse or text type", "", "descendant::l2o:l2o/l2o:languagemode", "For example, monologue, dialogue, list, article", "", true, true, "", "", "", "", "descendant::l2o:l2o", "<l2o:languagemode><langstring /></l2o:languagemode>" });

        //these two should be linked together
        assetMetaTable.Rows.Add(new object[] { 16, "5.19", "subtitleincluded", "Are there subtitles/translation?", "", "descendant::l2o:l2o/l2o:subtitles/l2o:subtitlesincluded", "If subtitles or a transcript is avail please indicate here", "", true, true, "Language", "", "descendant::l2o:l2o/l2o:subtitles/l2o:subtitleslanguage", "British English|French|German|Italian", "descendant::l2o:l2o", "<l2o:subtitles><l2o:subtitlesincluded><l2o:langstring></l2o:langstring></l2o:subtitlesincluded><l2o:subtitleslanguage></l2o:subtitleslanguage></l2o:subtitles>" });
        //assetMetaTable.Rows.Add(new object[] { 17, "5.19", "subtitlelanguage", "Language of subtitles", "", "descendant::l2o:l2o/l2o:subtitles/l2o:subtitleslanguage", "", "", true, true });
        assetMetaTable.Rows.Add(new object[] { 17, "5.20", "wordcount", "Approx Word-count or page count", "", "descendant::l2o:l2o/l2o:wordcount", "Please include the most accurate word count available. This is to give the idea of overall document size", "", true, true, "", "", "", "", "descendant::l2o:l2o", "<l2o:wordcount><l2o:langstring /></l2o:wordcount>" });

      
        
        assetMetaTable.Rows.Add(new object[] { 18, "6.3", "rights.description", "Copyright Holder", "", "descendant::imsmd:rights/child::imsmd:description", "Please consult your institutional IPR policy if you are unclear about this field", "", false, false, "", "", "", "", "", "" });

        //these two are interlinked 
       // assetMetaTable.Rows.Add(new object[] { 20, "7.1", "relation kind", "Kind of relation", "", "descendant::imsmd:relation/imsmd:kind/imsmd:value", "Select the kind of relationship", "", true, true });
       
        // assetMetaTable.Rows.Add(new object[] { 19, "7.2", "relation resource", "Name of related source(other LO, assets)", "", "descendant::imsmd:relation/imsmd:resource/imsmd:description", "Specify the source related to the current asset", "", true, true, "Relation", "", "descendant::imsmd:relation/imsmd:kind/imsmd:value", "IsPartOf|IsBasedOn|Requires|IsVersionOf", "descendant::imsmd:lom", "<imsmd:relation><imsmd:kind><imsmd:source><imsmd:langstring xml:lang=\"en\">LOMv1.0</imsmd:langstring></imsmd:source><imsmd:value><imsmd:langstring xml:lang=\"x-none\"></imsmd:langstring></imsmd:value></imsmd:kind><imsmd:resource><imsmd:description><imsmd:langstring xml:lang=\"en\"></imsmd:langstring></imsmd:description></imsmd:resource></imsmd:relation>"});
      
        //change the xpath expression, so that some lo with different path (only resource tag, no description tag) can be read as well
        assetMetaTable.Rows.Add(new object[] { 19, "7.2", "relation resource", "Name of related source(other LO, assets)", "", "descendant::imsmd:relation/imsmd:resource", "Specify the source related to the current asset", "", true, true, "Relation", "", "descendant::imsmd:relation/imsmd:kind/imsmd:value", "IsPartOf|IsBasedOn|Requires|IsVersionOf", "descendant::imsmd:lom", "<imsmd:relation><imsmd:kind><imsmd:source><imsmd:langstring xml:lang=\"en\">LOMv1.0</imsmd:langstring></imsmd:source><imsmd:value><imsmd:langstring xml:lang=\"x-none\"></imsmd:langstring></imsmd:value></imsmd:kind><imsmd:resource><imsmd:description><imsmd:langstring xml:lang=\"en\"></imsmd:langstring></imsmd:description></imsmd:resource></imsmd:relation>" });
        

        return assetMetaTable;
    }



    

    protected void GridViewDS_RowEditing(object sender, GridViewEditEventArgs e)
    {
        GridViewDS.EditIndex = e.NewEditIndex;
        
        int mType = 0;
        string assetName = null;
        if (Request.QueryString["mtype"] != null)
        {
            mType = Convert.ToInt32(Request.QueryString["mtype"]);
        }
        if (Request.QueryString["assetName"] != null)
        {
            assetName = Request.QueryString["assetName"].ToString();

        }
        BindGridView(mType,assetName);

        LinkButton lbtn = (LinkButton)GridViewDS.Rows[e.NewEditIndex].FindControl("BtnAddNew");
        lbtn.Visible = false;
        

        //skip the rest if this is for deleting purpose
        if (deletingFlag || insertingFlag)
        {
            return;
        }

        /*
        DataTable lotbl = Session["loMetaData"] as DataTable;
        if (lotbl == null)
        {
            lotbl = GetDataFromXml();
        }*/

        //replace above with this
        DataTable srcTbl = getCurrentMetaset();

        string valOpt = srcTbl.Rows[e.NewEditIndex]["options"].ToString();

        string metaVals = srcTbl.Rows[e.NewEditIndex]["metaVal"].ToString();
        string[] metaValArray = metaVals.Split(new char[] { '|' });

        /****************************************
        //to add the extra sub value field for the embeded value !! test
        *********************************************************************/
        string subName = "";
        string subVal = "";
        string[] subValArr = null;
        string subOptions = "";
        //#if (srcTbl.TableName != "lo")
       //# {
            subName = srcTbl.Rows[e.NewEditIndex]["subValueName"].ToString();
            if (subName.Length > 0)
            {
                subVal = srcTbl.Rows[e.NewEditIndex]["subValueVal"].ToString();
                subValArr = subVal.Split(new char[] { '|' });
                subOptions = srcTbl.Rows[e.NewEditIndex]["subValueOption"].ToString();
            }
       //# }
        /***************************************/


        TextBox textEdit = (TextBox)GridViewDS.Rows[e.NewEditIndex].Cells[2].FindControl("textbox_valEdit");

        HtmlGenericControl divMultiValues = (HtmlGenericControl)GridViewDS.Rows[e.NewEditIndex].Cells[2].FindControl("divMultiValues");
        
        /* when there are multiple values for one field */
        if (metaValArray.Length > 1)
        {
            for (int i = 0; i < metaValArray.Length; i++)
            {
                if (valOpt.Length > 0)
                {
                    DropDownList optionList = fillDropDownListItems(valOpt, metaValArray[i]);

                    optionList.ID = "multiDdlist_" + i.ToString();  //id is used to recognise this control and retrive value later

                    divMultiValues.Controls.Add(optionList);

                    /*************************sub values **********************************/
                    if (subName.Length > 0)
                    {
                        // HtmlGenericControl divSoloValue = (HtmlGenericControl)GridViewDS.Rows[e.NewEditIndex].FindControl("divSoloValue");

                        addSubValueFields(subName, subValArr, subOptions, divMultiValues,i);

                    }
                    /***************************************/

                    divMultiValues.Controls.Add(new LiteralControl("<br>"));

                    //Request.QueryString
                }
                else   // textbox for free value
                {
                    TextBox newBox = new TextBox();
                    newBox.Text = metaValArray[i];

                    newBox.ID = "multiText_" + i.ToString(); //identifier for later use

                    if (newBox.Text.Length > 50)
                    {
                        newBox.TextMode = TextBoxMode.MultiLine;
                        newBox.Width = 500;

                    }
                    divMultiValues.Controls.Add(newBox);

                    /*************************sub values **********************************/
                    if (subName.Length > 0)
                    {
                        // HtmlGenericControl divSoloValue = (HtmlGenericControl)GridViewDS.Rows[e.NewEditIndex].FindControl("divSoloValue");

                        addSubValueFields(subName, subValArr, subOptions, divMultiValues,i);

                    }
                    /***************************************/

                    //can't use divMultiValues.innerhtml (as the current content not literal !!
                    divMultiValues.Controls.Add(new LiteralControl("<br>"));

                }
            }

            textEdit.Visible = false;
        }
        else   //when there is only single value
        {
            if (valOpt.Length > 0)
            {

                DropDownList optionDdlist = fillDropDownListItems(valOpt, textEdit.Text);

                optionDdlist.ID = "singleList";
                
                divMultiValues.Controls.Add(optionDdlist);
                textEdit.Visible = false;

                /*************************sub values **********************************/
                if (subName.Length > 0)
                {
                   // HtmlGenericControl divSoloValue = (HtmlGenericControl)GridViewDS.Rows[e.NewEditIndex].FindControl("divSoloValue");

                    addSubValueFields(subName, subValArr, subOptions, divMultiValues, 0);                   
                    
                }
                /***************************************/

            }
            else  //this is the case for textbox editing
            {
                if (textEdit.Text.Length > 50)
                {
                    textEdit.TextMode = TextBoxMode.MultiLine;
                    textEdit.Width = 500;
                    
                }

                HtmlGenericControl divSoloValue = (HtmlGenericControl)GridViewDS.Rows[e.NewEditIndex].FindControl("divSoloValue");

                /*************************sub values **********************************/
                if (subName.Length > 0)
                {
                    // HtmlGenericControl divSoloValue = (HtmlGenericControl)GridViewDS.Rows[e.NewEditIndex].FindControl("divSoloValue");

                    addSubValueFields(subName, subValArr, subOptions, divSoloValue, 0);

                }
                /***************************************/
            }
        }
      
    }


    private void addSubValueFields(string subName, string[] subVals, string subOptions, HtmlGenericControl divField, int idx)
    {
        Label lblName = new Label();
        lblName.Text = subName + ": ";
        lblName.ForeColor = System.Drawing.Color.Chocolate;
        
        divField.Controls.Add(new LiteralControl("&nbsp;&nbsp;&nbsp;"));
        divField.Controls.Add(lblName);

        if (subOptions.Length > 0)
        {
            DropDownList subDdlist = null;
            if (subVals == null)   // for adding insert boxes 
            {
                subDdlist = fillDropDownListItems(subOptions, null);
                subDdlist.ID = "subInsertList";
            }
            else
            {
                subDdlist = fillDropDownListItems(subOptions, subVals[idx]);

                if (subVals.Length > 1)
                {
                    subDdlist.ID = "subMultiList_" + idx.ToString();
                }
                else
                {
                    subDdlist.ID = "subSingleList";
                }
            }

            divField.Controls.Add(subDdlist);
        }
        else   //no options for selecting
        {
            TextBox textBoxSubVal = new TextBox();
            if (subVals == null) //inserting box
            {
                textBoxSubVal.Text = "";
                textBoxSubVal.ID = "subInsertText";
            }
            else
            {
                textBoxSubVal.Text = subVals[idx];

                if (subVals.Length > 1)
                {
                    textBoxSubVal.ID = "subMultiText_" + idx.ToString();
                }
                else
                {
                    textBoxSubVal.ID = "subSingleText";
                }
            }

            divField.Controls.Add(textBoxSubVal);
        }
    }

    /*
     * to get the current metadata table for editing
     * it can be lo metadata or asset metadata
     * */
    private DataTable getCurrentMetaset()
    {
        DataSet metaSets = Session["metasets"] as DataSet;
        if (metaSets == null)
        {
            metaSets = GetDataFromXml();
        }

        int metaType = 0;
        string assetName = "";

        if (Request.QueryString["mtype"] != null)
        {
            metaType = Convert.ToInt32(Request.QueryString["mtype"]);
        }
        if (Request.QueryString["assetName"] != null)
        {
            assetName = Request.QueryString["assetName"].ToString();
            
        }

        DataTable srcTable = null;
        switch (metaType)
        {
            case 1:  //learning object metadata
                srcTable = metaSets.Tables["lo"];
                
                break;
            case 2:   //asset metadata
                srcTable = metaSets.Tables[assetName];
                break;
            default:
                goto case 1;
                
         }
         return srcTable;

    }


    protected void GridViewDS_RowCancelingEdit(object sender, GridViewCancelEditEventArgs e)
    {
        GridViewDS.EditIndex = -1;
        int mType = 0;
        string assetName = null;
        if (Request.QueryString["mtype"] != null)
        {
            mType = Convert.ToInt32(Request.QueryString["mtype"]);
        }                
        if (Request.QueryString["assetName"] != null)
        {
            assetName = Request.QueryString["assetName"].ToString();

        }
        BindGridView(mType,assetName);
    }


    protected void GridViewDS_RowUpdating(object sender, GridViewUpdateEventArgs e)
    {

       // Response.Write("Value is : " + Request["GridViewDS$ctl03$multiDdlist_0"] + " and " + Request["GridViewDS$ctl03$multiDdlist_1"]);
    

        TextBox editBox = (TextBox)GridViewDS.Rows[e.RowIndex].Cells[2].FindControl("textbox_valEdit");
        //or use  GridViewDS.Rows[e.RowIndex].FindControl("textbox_valEdit")
        
        string singleValue = null;
        ArrayList multiValArr = new ArrayList();

        /************for sub value only*******************/
        string subSingleVal = null;
        ArrayList subMultiVal = new ArrayList();
        /**********************************/
         
        if (editBox.Visible == true)
        {
            singleValue = editBox.Text;
        }

        for (int i = 0; i < Request.Form.Count; i++)
        {
            if (Request.Form.Keys[i].IndexOf("singleList") >= 0)
            {
                singleValue = Request.Form[i];
                
            }
            else if (Request.Form.Keys[i].IndexOf("multiDdlist") >= 0)
            {
                multiValArr.Add(Request.Form[i]);
            }
            else if (Request.Form.Keys[i].IndexOf("multiText") >= 0)
            {
                multiValArr.Add(Request.Form[i]);
            }

            /************for sub values****************************/
            else if (Request.Form.Keys[i].IndexOf("subSingle") >= 0)
            {
                subSingleVal = Request.Form[i];
            }
            else if (Request.Form.Keys[i].IndexOf("subMulti") >= 0)
            {
                subMultiVal.Add(Request.Form[i]);
            }
            /****************************/

        }
       

        

       
        int editId = System.Convert.ToInt32(GridViewDS.DataKeys[e.RowIndex].Value.ToString());

        int mType = 0;
        if (Request.QueryString["mtype"] != null)
        {
            mType = Convert.ToInt32(Request.QueryString["mtype"]);
        }  

        /*
        DataTable lotbl = Session["loMetaData"] as DataTable;
        if (lotbl == null)
        {
            Response.Write("No metadata loaded");
            return;
        }*/
        DataTable srcTbl = getCurrentMetaset();

        DataRow[] currRow = srcTbl.Select("metaId=" + editId);

        if (singleValue != null)
        {
            currRow[0]["metaVal"] = singleValue;

            updateXml(mType, currRow[0]["xpathExp"].ToString(), new string[1] {singleValue}, srcTbl.TableName);

            /**********************sub value*****************/
            if (subSingleVal != null)
            {
                currRow[0]["subValueVal"] = subSingleVal;
                updateXml(mType, currRow[0]["subValuePath"].ToString(), new string[1] { subSingleVal }, srcTbl.TableName);
            }
            /****************/
        }
        else if (multiValArr.Count > 0)
        {
            string mVal = "";
            foreach (object obj in multiValArr)
            {
                mVal += obj.ToString() + "|";
            }
            mVal = mVal.Substring(0, mVal.Length - 1); //remove the last "|"

            currRow[0]["metaVal"] = mVal;

            string[] strArr = (string[])multiValArr.ToArray(typeof(string));

            updateXml(mType, currRow[0]["xpathExp"].ToString(), strArr,srcTbl.TableName);

            /**********************sub value*****************/
            if (subMultiVal.Count > 0)
            {
                string subVals = "";
                foreach (object obj1 in subMultiVal)
                {
                    subVals += obj1.ToString() + "|";
                }
                subVals = subVals.Substring(0, subVals.Length - 1);

                currRow[0]["subValueVal"] = subVals;
                
                string[] subArr =(string[])subMultiVal.ToArray(typeof(string));

                updateXml(mType, currRow[0]["subValuePath"].ToString(),subArr, srcTbl.TableName);
            }
            /****************/

        }


        //lotbl.Rows[editId-1]["metaVal"] = editBox.Text.Trim();

        
        // editBox.TextMode = TextBoxMode.MultiLine;
        // editBox.Text = "i have been changed!";

        GridViewDS.EditIndex = -1;

        //useful?? TODO: Consider updating session here??
       // Session["loMetaData"] = srcTbl;
        
        //update datatable, and xml, bindgrid
        GridViewDS.DataSource = srcTbl;
        GridViewDS.DataBind();

    }



    private void updateXml(int metaType, string xpathStr, string[] newValues, string assetNm)
    {
        string xmlpath = Server.MapPath(@"App_Data\imsmanifest.xml");

        XmlDataDocument xdd = new XmlDataDocument();

        xdd.Load(xmlpath);

        XmlNamespaceManager nsmanager = new XmlNamespaceManager(xdd.NameTable);

        /* have to declare a name even it is default namespace no prefix, can not 
         * use String.Empty as recommended somewhere. 
         * see http://msdn2.microsoft.com/en-us/library/d271ytdx.aspx
         * */
        nsmanager.AddNamespace("df", "http://www.imsglobal.org/xsd/imscp_v1p1");
        nsmanager.AddNamespace("imsmd", "imsmd_v1p2_localised_Schema");
        nsmanager.AddNamespace("l2o", "imsmd_v1p2_l2o_localised_Schema");


        XmlElement root = xdd.DocumentElement;
        XmlNodeList metadataNodes = xdd.SelectNodes("descendant::df:metadata", nsmanager);

        if (metaType == 1 || metaType == 0)  //lo
        {
            foreach (XmlNode metaNode in metadataNodes)
            {
               // if (metaNode.ParentNode.Name == "resource" && metaNode.ParentNode.Attributes["href"].Value.IndexOf("index.htm") >= 0)
                if (metaNode.ParentNode.Name == "resource" || metaNode.ParentNode.Name == "manifest")
                {
                    //this is the learning object metadata section 
                    //only one title field existing (textBox)
                    XmlNodeList currentNodes = metaNode.SelectNodes(xpathStr, nsmanager);
                    
                    //replace with new function
                    updateNodesInXml(ref currentNodes, newValues);
                     
                    xdd.Save(xmlpath);

                    break;
                }
            }
        }
        else if (metaType == 2)
        {
            foreach (XmlNode metaNode in metadataNodes)
            {
                if (metaNode.ParentNode.Name == "file" && metaNode.ParentNode.Attributes["href"].Value.IndexOf(assetNm) != -1)
                {
                    XmlNodeList currentNodes = metaNode.SelectNodes(xpathStr, nsmanager);

                    updateNodesInXml(ref currentNodes, newValues);
                    xdd.Save(xmlpath);

                    break;
                }
            }
        }

    }

    //update the xml file with the set of nodes affected
    private void updateNodesInXml(ref XmlNodeList nodelist, string[] newVals)
    {
        if (newVals.Length == 1) //textbox type and dropdownlist type(single value)
        {
            XmlNode innerNode = nodelist.Item(0);
            while (innerNode.HasChildNodes)
            {
                innerNode = innerNode.FirstChild;
            }
            innerNode.InnerText = newVals[0];
        }
        else if (newVals.Length > 1)
        {
            for (int i = 0; i < nodelist.Count; i++)
            {
                XmlNode iNode = nodelist.Item(i);
                while (iNode.HasChildNodes)
                {
                    iNode = iNode.FirstChild;
                }
                iNode.InnerText = newVals[i];
            }
        }
    }


    /* prepare options for a dropdown list and the selected value, return dropdown list to 
     * be added into the div area*/
    private DropDownList fillDropDownListItems(string optlist, string metaVal)
    {
        string[] options = optlist.Split(new char[] { '|' });
        DropDownList valList = new DropDownList();
        bool isInList = false; //flag indicating the value in list or not
        string selectedVal = "";
        if (metaVal == null)
        {
            foreach (string opt1 in options)
            {
                ListItem ls1 = new ListItem(opt1);
                valList.Items.Add(ls1);

            }
        }
        else
        {
            foreach (string opt1 in options)
            {
                ListItem ls1 = new ListItem(opt1);
                valList.Items.Add(ls1);
                //determine if the current value is in the option list (ignore case)
                if (opt1.ToLower() == metaVal.ToLower())
                {
                    isInList = true;
                    selectedVal = opt1;
                }
            }

            if (isInList)
            {
                valList.SelectedValue = selectedVal;
            }
            else
            {
                /*temp solution - when the value is not in the list, it shouldn't happen */
                ListItem li = new ListItem(metaVal);
                valList.Items.Add(li);
                valList.SelectedValue = metaVal;

            }
        }

        return valList;
    }


    protected void GridViewDS_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        if (e.Row.RowType == DataControlRowType.DataRow)
        {
            //e.Row.RowIndex;
            //HtmlGenericControl divMultiFields = (HtmlGenericControl)GridViewDS.Rows[e.Row.RowIndex].FindControl("divMultiFields");
            
            HtmlGenericControl divMultiFields = (HtmlGenericControl)e.Row.FindControl("divMultiFields");

            /*
            DataTable lotbl = Session["loMetaData"] as DataTable;
            if (lotbl == null)
            {
                lotbl = GetDataFromXml();
            }*/
            DataTable srcTbl = getCurrentMetaset();


            //set up tooltop message
            Image imgHelp = (Image)e.Row.FindControl("ImgHelp");
            string helpMsg = srcTbl.Rows[e.Row.RowIndex]["description"].ToString();
            imgHelp.ToolTip = helpMsg;
            //end of tooptip

            
            string metaVals = srcTbl.Rows[e.Row.RowIndex]["metaVal"].ToString();
            //if metaVals is empty, metaValArray will include one empty string as well
            string[] metaValArray = metaVals.Split(new char[] { '|' });

            /****************************************
             //to add the extra sub value field for the embeded value !! test
             *********************************************************************/
            string subName = "";
            string subVal = "";
            string[] subValArr = null;
           // if (srcTbl.TableName != "lo")
           // {
                subName = srcTbl.Rows[e.Row.RowIndex]["subValueName"].ToString();
                if (subName.Length > 0)
                {
                    subVal = srcTbl.Rows[e.Row.RowIndex]["subValueVal"].ToString();
                    subValArr = subVal.Split(new char[] { '|' });
                }
           // }
            /***************************************/

            if (metaValArray.Length > 1)
            {                

                Label lblValue = (Label)e.Row.FindControl("valDisplay");
                if (lblValue != null)
                {  /* in the case when row is being edited, the itemtemplate for display value is not 
                    available , such as the label; as the rowdatabound is called when gridview databind()
                    * method is called */

                    lblValue.Visible = false;

                    for (int i = 0; i < metaValArray.Length; i++)
                    {
                        divMultiFields.Controls.Add(new LiteralControl(metaValArray[i]));

                        /****************************************
                         //to add the extra sub value field for the embeded value !! test
                       *********************************************************************/
                        
                        if (subValArr != null && subValArr.Length > 1)
                        {
                            divMultiFields.Controls.Add(new LiteralControl("&nbsp;&nbsp;&nbsp;"));
                            
                            Label lblName = new Label();
                            lblName.Text = subName + ": ";
                            lblName.ForeColor = System.Drawing.Color.Chocolate;

                            Label lblVal = new Label();
                            lblVal.Text = subValArr[i];

                            divMultiFields.Controls.Add(lblName);
                            divMultiFields.Controls.Add(lblVal);
                        }

                        /*********************************************************************/

                        divMultiFields.Controls.Add(new LiteralControl("<br>"));
                    }
                }

                //########### disable delete and add button

                //find the default delete button, add alert message to delete button
                LinkButton delBn = null;

                if (e.Row.Cells[4].Controls.Count > 0)  //important, the one is deleted will lose the control item
                {
                    delBn = e.Row.Cells[4].Controls[0] as LinkButton;
                }


                LinkButton insertBtn = (LinkButton)e.Row.FindControl("BtnAddNew");

                Boolean canInsert = (Boolean)srcTbl.Rows[e.Row.RowIndex]["canInsert"];
                if (!canInsert)
                {
                    insertBtn.Enabled = false;
                }

                Boolean canDel = (Boolean)srcTbl.Rows[e.Row.RowIndex]["canDelete"];
                if (delBn != null && delBn.Text == "Delete")
                {
                    if (!canDel)
                    {
                        delBn.Enabled = false;
                        return;
                    }
                    delBn.Attributes.Add("onclick", "return confirm(\"Are you sure you want to delete this data?\");");
                }
                //###################

            }
            else   //when there is only one single value or empty
            {
                //find the default delete button, add alert message to delete button
                LinkButton delBn = null;

                if (e.Row.Cells[4].Controls.Count > 0)  //important, the one is deleted will lose the control item
                {
                    delBn = e.Row.Cells[4].Controls[0] as LinkButton;
                }

                
                LinkButton insertBtn = (LinkButton)e.Row.FindControl("BtnAddNew");

                if (metaVals != "")
                /* when there is only one value */
                {
                    //apply insert restrictions and delete restrictions
                    Boolean canInsert = (Boolean)srcTbl.Rows[e.Row.RowIndex]["canInsert"];
                    if (!canInsert)
                    {
                        insertBtn.Enabled = false;
                    }

                    Boolean canDel = (Boolean)srcTbl.Rows[e.Row.RowIndex]["canDelete"];
                    if (delBn != null && delBn.Text == "Delete")
                    {
                        if (!canDel)
                        {
                            delBn.Enabled = false;
                            //#return;
                        }
                        delBn.Attributes.Add("onclick", "return confirm(\"Are you sure you want to delete this data?\");");
                    }

                    /****************************************
                    //to add the extra sub value field for the embeded value !! test
                     *********************************************************************/
                   // if (srcTbl.TableName == "lo")
                   //     return;
                    string subName2 = srcTbl.Rows[e.Row.RowIndex]["subValueName"].ToString();
                    if (subName2 != null && subName2.Length > 0)
                    {
                        string subVal2 = srcTbl.Rows[e.Row.RowIndex]["subValueVal"].ToString();
                        HtmlGenericControl divSoloField = (HtmlGenericControl)e.Row.FindControl("divSoloField");
                        if (divSoloField == null)
                            return;
                        Label lblName2 = new Label();
                        lblName2.Text = subName2 + ": ";
                        lblName2.ForeColor = System.Drawing.Color.Chocolate;

                        Label lblVal2 = new Label();
                        lblVal2.Text = subVal2;
                        divSoloField.Controls.Add(new LiteralControl("&nbsp;&nbsp;&nbsp;"));
                        divSoloField.Controls.Add(lblName2);
                        divSoloField.Controls.Add(lblVal2);
                    }

                   /*********************************************************************/
                   
                }
                    
                }

            }
           
        }


    protected void GridViewDS_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        
        //e.Cancel = true;
       // Response.Write("cancelled");
       //GridViewDS.EditIndex = e.RowIndex;

         int mType = 0;
        if (Request.QueryString["mtype"] != null)
        {
            mType = Convert.ToInt32(Request.QueryString["mtype"]);
        }  

        /*
        DataTable lotbl = Session["loMetaData"] as DataTable;
        if (lotbl == null)
        {
            lotbl = GetDataFromXml();
        }*/
        DataTable srcTbl = getCurrentMetaset();

        DataRow iRow = srcTbl.Rows[e.RowIndex];

        string listVals = srcTbl.Rows[e.RowIndex]["metaVal"].ToString();
        string[] listValArray = listVals.Split(new char[] { '|' });

        /****************************************
       //to add the extra sub value field for the embeded value !! test
       *********************************************************************/
        string subName = ""; 
        string subVal = "";
        string[] subValArr = null;
        if (srcTbl.TableName != "lo")
        {
            subName = srcTbl.Rows[e.RowIndex]["subValueName"].ToString();
            if (subName.Length > 0)
            {
                subVal = srcTbl.Rows[e.RowIndex]["subValueVal"].ToString();
                subValArr = subVal.Split(new char[] { '|' });
                
            }
        }
        /***************************************/

        if (listValArray.Length == 1)//when it is single value
        {
            
            iRow["metaVal"] = "";
            //todo, update xml
            DeleteFromXml(mType, iRow["xpathExp"].ToString(), null, false, srcTbl.TableName);

            /***************************sub value********/
            if (subName.Length > 0)
            {
                iRow["subValueVal"] = "";

                DeleteFromXml(mType, iRow["subValuePath"].ToString(), null, false, srcTbl.TableName);
            }
            /***********************/

            GridViewDS.EditIndex = -1;
            
            GridViewDS.DataSource = srcTbl;
            GridViewDS.DataBind();
            
        }
        /* when there are multiple values for one field */
        else if (listValArray.Length > 1)
        {

            //record index session for use in BtbDel click event
            Session["deleteIndex"] = e.RowIndex;

            //set status for deleting, to be used in editing function..
            deletingFlag = true;

            this.GridViewDS_RowEditing(sender, new GridViewEditEventArgs(e.RowIndex));

            //make some controls designed for editing etc invisible
            disableControls(GridViewDS.Rows[e.RowIndex]);
           

            HtmlGenericControl divDeleting = (HtmlGenericControl)GridViewDS.Rows[e.RowIndex].Cells[2].FindControl("divDeleting");

            //divMultiValues.InnerHtml += "<b>delete test</b>";

            CheckBoxList cbl = (CheckBoxList)divDeleting.FindControl("cblistDeleting");

            Button btDel = (Button)divDeleting.FindControl("BtnDel");

            btDel.Attributes.Add("onclick", "return confirm(\"Are you sure you want to delete this record?\");");

            
            for (int i = 0; i < listValArray.Length; i++)
            {
                ListItem ls1 = new ListItem(listValArray[i]);
                ls1.Selected = false;
                cbl.Items.Add(ls1);
            }

            divDeleting.Visible = true;

        }
       
       
        //set deleting flag
        deletingFlag = false;
      
    }


    private void DeleteFromXml(int metaType, string xpathStr, string[] deleteValues, bool delAll, string assetNm)
    {
        string xmlpath = Server.MapPath(@"App_Data\imsmanifest.xml");

        XmlDataDocument xdd = new XmlDataDocument();

        xdd.Load(xmlpath);

        XmlNamespaceManager nsmanager = new XmlNamespaceManager(xdd.NameTable);

        /* have to declare a name even it is default namespace no prefix, can not 
         * use String.Empty as recommended somewhere. 
         * see http://msdn2.microsoft.com/en-us/library/d271ytdx.aspx
         * */
        nsmanager.AddNamespace("df", "http://www.imsglobal.org/xsd/imscp_v1p1");
        nsmanager.AddNamespace("imsmd", "imsmd_v1p2_localised_Schema");
        nsmanager.AddNamespace("l2o", "imsmd_v1p2_l2o_localised_Schema");
        
        XmlElement root = xdd.DocumentElement;
        XmlNodeList metadataNodes = xdd.SelectNodes("descendant::df:metadata", nsmanager);

        if (metaType == 1 || metaType == 0)
        {
            foreach (XmlNode metaNode in metadataNodes)
            {
               // if (metaNode.ParentNode.Name == "resource" && metaNode.ParentNode.Attributes["href"].Value.IndexOf("index.htm") >= 0)
                if (metaNode.ParentNode.Name == "resource" || metaNode.ParentNode.Name == "manifest")
                {
                    
                    XmlNodeList currentNodes = metaNode.SelectNodes(xpathStr, nsmanager);
                                        

                    //replace with this funtion

                    deleteNodesfromXml(ref currentNodes, deleteValues, delAll);

                    xdd.Save(xmlpath);

                    break;
                }


            }
        }
        else if (metaType == 2)
        {
            foreach (XmlNode metaNode in metadataNodes)
            {
                if (metaNode.ParentNode.Name == "file" && metaNode.ParentNode.Attributes["href"].Value.IndexOf(assetNm) != -1)
                {
                    XmlNodeList currentNodes = metaNode.SelectNodes(xpathStr, nsmanager);

                    deleteNodesfromXml(ref currentNodes, deleteValues, delAll);

                    xdd.Save(xmlpath);

                    break;
                }
            }
        }

    }

    //delete specific nodes from the current xml file
    private void deleteNodesfromXml(ref XmlNodeList nodelist, string[] delVals, bool delAll)
    {
        if (delVals == null) //only have one value to remove
        {
            XmlNode iNode = nodelist.Item(0);

            /*
            if (iNode.Name == "imsmd:value" && iNode.PreviousSibling.Name == "imsmd:source")
            {
                iNode = iNode.ParentNode;                            
            }
            while (iNode.ParentNode.InnerText == iNode.InnerText)
            {
                    iNode = iNode.ParentNode;
            }

            iNode.ParentNode.RemoveChild(iNode);
            */

            /* instead of removing the whole node, just remove the innerText 
             * of the node if it is the only one or last one of kind (opposed to above)
             * */
            while (iNode.HasChildNodes)
            {
                iNode = iNode.FirstChild;
            }
            iNode.InnerText = "";

        }

        else   //when more than one deleted values are selected
        {
            if (delAll)
            {
                XmlNode iNode = null;
                for (int i = 0; i < nodelist.Count - 1; i++)
                {
                    iNode = nodelist.Item(i);
                    if (iNode.Name == "imsmd:value" && iNode.PreviousSibling.Name == "imsmd:source")
                    {
                        iNode = iNode.ParentNode;
                    }
                    while (iNode.ParentNode.InnerText == iNode.InnerText)
                    {
                        iNode = iNode.ParentNode;
                    }

                    iNode.ParentNode.RemoveChild(iNode);

                }
                //empty the last node , not removing
                iNode = nodelist.Item(nodelist.Count - 1);
                while (iNode.HasChildNodes)
                {
                    iNode = iNode.FirstChild;
                }
                iNode.InnerText = "";
            }
            else   //delete part of the items
            {
                foreach (string strToDel in delVals)
                {
                    deleteSelectedNodes(strToDel, nodelist);
                }
            }

        }

    }

    private void deleteSelectedNodes(string toDel, XmlNodeList nodes)
    {
        XmlNode iNode = null;
        for (int i = 0; i < nodes.Count; i++)
        {
            iNode = nodes.Item(i);
            if (iNode.InnerText == toDel)
            {
                if (iNode.Name == "imsmd:value" && iNode.PreviousSibling.Name == "imsmd:source")
                {
                    iNode = iNode.ParentNode;
                }
                while (iNode.ParentNode.InnerText == iNode.InnerText)
                {
                    iNode = iNode.ParentNode;
                }

                iNode.ParentNode.RemoveChild(iNode);
                break;
            }

        }   
    }



    protected void BtnDel_Click(object sender, EventArgs e)
    {
        int idx = -1;
        if (Session["deleteIndex"] == null)
        {
            Response.Write("No data selected for deleting");
            return;
        }
        else
            idx = (int)Session["deleteIndex"];

        int mType = 0;
        if (Request.QueryString["mtype"] != null)
        {
            mType = Convert.ToInt32(Request.QueryString["mtype"]);
        }  

        /*
        DataTable lotbl = Session["loMetaData"] as DataTable;
        if (lotbl == null)
        {
            lotbl = GetDataFromXml();
        }*/
        DataTable srcTbl = getCurrentMetaset();

        DataRow iRow = srcTbl.Rows[idx];

        //string listVals = srcTbl.Rows[idx]["metaVal"].ToString();

      /****************************************
      //to add the extra sub value field for the embeded value !! test
      *********************************************************************/
        string subName = "";
        string subVal = "";
        string[] subValArr = null;
        if (srcTbl.TableName != "lo")
        {
            subName = iRow["subValueName"].ToString();
            if (subName.Length > 0)
            {
                subVal = iRow["subValueVal"].ToString();
                subValArr = subVal.Split(new char[] { '|' });

            }
        }

        ArrayList subDelArr = new ArrayList();
        string remainSubVals = "";
        /***************************************/
        
        HtmlGenericControl divDeleting = (HtmlGenericControl)GridViewDS.Rows[idx].Cells[2].FindControl("divDeleting");

        CheckBoxList cbl = (CheckBoxList)divDeleting.FindControl("cblistDeleting");
        
        ArrayList delArr = new ArrayList();
        string remainVals = "";

        

        for (int i =0; i < cbl.Items.Count; i++)
        //foreach (ListItem ilist in cbl.Items)
        {
            if (cbl.Items[i].Selected)
            {
                delArr.Add(cbl.Items[i].Text);
                /***********sub value***************/
                if (subName.Length > 0)
                {
                    subDelArr.Add(subValArr[i]);
                }
                /***************/
            }
            else
            {
                remainVals += cbl.Items[i].Text + "|";
                /***********sub value***************/
                if (subName.Length > 0)
                {
                    remainSubVals += subValArr[i] + "|";
                }
                /***************/
            }
        }

        /* when all nodes are to be delelted */
        if (remainVals == "")
        {
            if ((Boolean)iRow["canDelete"])
            {
                iRow["metaVal"] = "";

                /***********sub value***************/
                if (subName.Length > 0)
                {
                    iRow["subValueVal"] = "";
                }
                /*************/
            }
            else
            {
                LblErrMsg.Text = "You can't delete all the metadata from this field!";
                LblErrMsg.ForeColor = System.Drawing.Color.Red;
                //Response.Write("You can't delete all the metadata from this field!");
                return;
            }

        }
        else
        {
            //update the data table row
            iRow["metaVal"] = remainVals.Substring(0, remainVals.Length - 1);

            /***********sub value***************/
            if (subName.Length > 0)
            {
                iRow["subValueVal"] = remainSubVals.Substring(0, remainSubVals.Length - 1);
            }
            /*************/
        }

        GridViewDS.EditIndex = -1;

        GridViewDS.DataSource = srcTbl;
        GridViewDS.DataBind();

        string[] delItems = (string[])delArr.ToArray(typeof(string));

       

        //upadate xml file
        if (remainVals == "")   //delete all
        {
            DeleteFromXml(mType, iRow["xpathExp"].ToString(), delItems, true, srcTbl.TableName);
            
            /****************sub value************/
            if (subDelArr.Count > 0)
            {
                string[] subDelItems = (string[])subDelArr.ToArray(typeof(string));
                DeleteFromXml(mType, iRow["subValuePath"].ToString(), subDelItems, true, srcTbl.TableName);
            }
            /****************/
        }
        else
        {
            DeleteFromXml(mType, iRow["xpathExp"].ToString(), delItems, false, srcTbl.TableName);

            /****************sub value************/
            if (subDelArr.Count > 0)
            {
                string[] subDelItems = (string[])subDelArr.ToArray(typeof(string));
                DeleteFromXml(mType, iRow["subValuePath"].ToString(), subDelItems, false, srcTbl.TableName);
            }
        }

        //clear delete index
        Session["deleteIndex"] = null;
    }


    protected void BtnBack_Click(object sender, EventArgs e)
    {
        GridViewDS.EditIndex = -1;
        int mType = 0;
        string assetName = null;
        if (Request.QueryString["mtype"] != null)
        {
            mType = Convert.ToInt32(Request.QueryString["mtype"]);
        }
        if (Request.QueryString["assetName"] != null)
        {
            assetName = Request.QueryString["assetName"].ToString();

        }
        
        BindGridView(mType, assetName);
       
    }


    protected void BtnCancelInsert_Click(object sender, EventArgs e)
    {
        GridViewDS.EditIndex = -1;
        int mType = 0;
        string assetName = null;
        if (Request.QueryString["mtype"] != null)
        {
            mType = Convert.ToInt32(Request.QueryString["mtype"]);
        }
        if (Request.QueryString["assetName"] != null)
        {
            assetName = Request.QueryString["assetName"].ToString();

        }
        
        BindGridView(mType, assetName);
    }


    protected void GridViewDS_RowCommand(object sender, GridViewCommandEventArgs e)
    {
        if (e.CommandName == "AddNew")
        {
            //commandArguemnt is link to metaId, needs to be zero based
            int rIndex = Convert.ToInt32(e.CommandArgument)-1;
            
            DataTable srcTbl = getCurrentMetaset();

            DataRow iRow = srcTbl.Rows[rIndex];

            Session["insertIndex"] = rIndex;

            //set flag for inserting
            insertingFlag = true;

            this.GridViewDS_RowEditing(sender, new GridViewEditEventArgs(rIndex));

            disableControls(GridViewDS.Rows[rIndex]);


            string valOptions = srcTbl.Rows[rIndex]["options"].ToString();

            string metaVals = srcTbl.Rows[rIndex]["metaVal"].ToString();

            HtmlGenericControl divInserting = (HtmlGenericControl)GridViewDS.Rows[rIndex].FindControl("divInserting");

            HtmlGenericControl divInsertArea = (HtmlGenericControl)GridViewDS.Rows[rIndex].FindControl("insertArea");

            /****************************************
           //to add the extra sub value field for the embeded value !! 
          *********************************************************************/
            string subName = "";
            string subOptions = "";
            if (srcTbl.TableName != "lo")
            {
                subName = srcTbl.Rows[rIndex]["subValueName"].ToString();
                if (subName.Length > 0)
                {
                    subOptions = srcTbl.Rows[rIndex]["subValueOption"].ToString();
                }
            }
            /***************************************/

            if (valOptions.Length > 0)
            {
                DropDownList optionList = fillDropDownListItems(valOptions, null);

                optionList.ID = "insertList";  //id is used to recognise this control and retrive value later

                divInsertArea.Controls.Add(optionList);
                
            }
            else   // textbox for free value
            {
                TextBox newBox = new TextBox();
                
                newBox.ID = "insertBox"; //identifier for later use

                divInsertArea.Controls.Add(newBox);
                
            }

            /*************************sub values **********************************/
            if (subName.Length > 0)
            {
                
                addSubValueFields(subName, null, subOptions, divInsertArea, 0);

            }
            /***************************************/

            divInserting.Visible = true;

        }

    }


    private void disableControls(GridViewRow curRow)
    {
        TextBox textEdit = (TextBox)curRow.Cells[2].FindControl("textbox_valEdit");

        textEdit.Visible = false;

        //...disable the update/cancel buttons
        LinkButton cancelBtn1 = null;
        LinkButton updateBtn1 = null;

        for (int i = 0; i < curRow.Cells[3].Controls.Count; i++)
        {
            if (updateBtn1 != null && cancelBtn1 != null)
            {
                break;
            }
            LinkButton btn1 = curRow.Cells[3].Controls[i] as LinkButton;
            if (btn1 != null && btn1.Text == "Update")
            {
                updateBtn1 = btn1;
            }
            else if (btn1 != null && btn1.Text == "Cancel")
            {
                cancelBtn1 = btn1;
            }
        }

        if (updateBtn1 != null)
        {
            updateBtn1.Visible = false;
        }

        if (cancelBtn1 != null)
        {
            cancelBtn1.Visible = false;
        }

        //...end of update/cancel btn visible setting

    }


    protected void BtnInsertNew_Click(object sender, EventArgs e)
    {
        int idx;
        if (Session["insertIndex"] == null)
        {
            Response.Write("Please click the Add button");
            return;
        }
        else
            idx = (int)Session["insertIndex"];


        int mType = 0;
        if (Request.QueryString["mtype"] != null)
        {
            mType = Convert.ToInt32(Request.QueryString["mtype"]);
        }  

        
        DataTable srcTbl = getCurrentMetaset();

        DataRow iRow = srcTbl.Rows[idx];

        string metaVals = srcTbl.Rows[idx]["metaVal"].ToString();
        string newVal= null;

        /****************************************
        //to add the extra sub value field for the embeded value !! 
       *********************************************************************/
        string subVal = "";
        string subName = "";
        //>>>>>>>>>> insert xml parts
        string insertPath = "";
        string xmlStr = "";

        if (srcTbl.TableName != "lo")
        {
            subName = srcTbl.Rows[idx]["subValueName"].ToString();
            if (subName.Length > 0)
            {
                subVal = srcTbl.Rows[idx]["subValueVal"].ToString();
            }

            //>>>>>>>>
            insertPath = srcTbl.Rows[idx]["insertPos"].ToString();
            xmlStr = srcTbl.Rows[idx]["xmlSnippet"].ToString();
        }
        string newSubVal = "";
        /***************************************/

        for (int i = 0; i < Request.Form.Count; i++)
        {
            if (Request.Form.Keys[i].IndexOf("insertList") >= 0 || Request.Form.Keys[i].IndexOf("insertBox") >= 0)
            {
                newVal = Request.Form[i];
                if (metaVals == "")
                {
                    metaVals = newVal;
                }
                else
                {
                    metaVals += "|" + newVal;                    
                }
                
            }
            /***********************sub Value************************/
            else if (Request.Form.Keys[i].IndexOf("subInsert") >= 0)  //include "subInsertList" "subInsertBox"
            {
                newSubVal = Request.Form[i];
                if (subVal == "")
                {
                    subVal = newSubVal;
                }
                else
                {
                   subVal += "|" + newSubVal;
                }
               

            }
            /*************************************************/

        }

        iRow["metaVal"] = metaVals;
 
        /********************sub value****************/
        if (newSubVal.Length > 0)
        {
            iRow["subValueVal"] = subVal;
            InsertIntoXml(mType, iRow["xpathExp"].ToString(), newVal, srcTbl.TableName, newSubVal, iRow["subValuePath"].ToString(),insertPath,xmlStr);
                
        }
        else  //normal situation without subvalue
        {
            // update xml
            InsertIntoXml(mType, iRow["xpathExp"].ToString(), newVal, srcTbl.TableName,null,null,insertPath,xmlStr); 
        }
        /********************/

        GridViewDS.EditIndex = -1;

        GridViewDS.DataSource = srcTbl;
        GridViewDS.DataBind();
        
       

        Session["insertIndex"] = null;

    }



    private void InsertIntoXml(int metaType, string xpathStr, string newValue, string assetNm,string newSubVal, string subPath,string insPath,string xmlStr)
    {
        string xmlpath = Server.MapPath(@"App_Data\imsmanifest.xml");

        XmlDataDocument xdd = new XmlDataDocument();

        xdd.Load(xmlpath);
        //XmlSchemaSequence ew = new XmlSchemaSequence();
        //XmlSchemaSet xss = new XmlSchemaSet();
        XmlNamespaceManager nsmanager = new XmlNamespaceManager(xdd.NameTable);

        /* have to declare a name even it is default namespace no prefix, can not 
         * use String.Empty as recommended somewhere. 
         * see http://msdn2.microsoft.com/en-us/library/d271ytdx.aspx
         * */
        nsmanager.AddNamespace("df", "http://www.imsglobal.org/xsd/imscp_v1p1");
        nsmanager.AddNamespace("imsmd", "imsmd_v1p2_localised_Schema");
        nsmanager.AddNamespace("l2o", "imsmd_v1p2_l2o_localised_Schema");

        XmlElement root = xdd.DocumentElement;
        XmlNodeList metadataNodes = xdd.SelectNodes("descendant::df:metadata", nsmanager);

        if (metaType == 1 || metaType == 0)
        {
            foreach (XmlNode metaNode in metadataNodes)
            {
                //if (metaNode.ParentNode.Name == "resource" && metaNode.ParentNode.Attributes["href"].Value.IndexOf("index.htm") >= 0)
                if (metaNode.ParentNode.Name == "resource" || metaNode.ParentNode.Name == "manifest")
                {

                    XmlNodeList currentNodes = metaNode.SelectNodes(xpathStr, nsmanager);

                    //.....................
                    if (currentNodes.Count == 0)
                    {
                        LblErrMsg.Text = "Couldn't update this value to XML file, the XML file needs to be updated";
                        LblErrMsg.ForeColor = System.Drawing.Color.Red;
                        return;
                        
                    }
                    //>>>>>>>>>>>>>>>>>>>>>>>>>>>

                    insertNodesToXml(ref currentNodes, newValue);


                    xdd.Save(xmlpath);

                    break;
                }
            }
        }
        else if (metaType == 2)
        {
            foreach (XmlNode metaNode in metadataNodes)
            {
                if (metaNode.ParentNode.Name == "file" && metaNode.ParentNode.Attributes["href"].Value.IndexOf(assetNm) != -1)
                {
                    XmlNodeList currentNodes = metaNode.SelectNodes(xpathStr, nsmanager);

                    //>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                    //in this way, the squenece is not correct, won't be validated
                    // and namespace is not completely correct. eg.l2o
                    if (currentNodes.Count == 0)
                    {
                        if (insPath == "")
                        {
                            LblErrMsg.Text = "Couldn't update this value to XML file, the XML file needs to be updated";
                            LblErrMsg.ForeColor = System.Drawing.Color.Red;
                            return;
                        }

                        XmlNodeList parentNodes = metaNode.SelectNodes(insPath, nsmanager);

                        //when the parent node is not existing
                        if (parentNodes.Count == 0)
                        {
                            string parentXml = insPath.Substring(insPath.LastIndexOf("/") + 1);
                            XmlElement parentNd = xdd.CreateElement(parentXml, "imsmd_v1p2_l2o_localised_Schema");

                            string newPath = insPath.Substring(0, insPath.LastIndexOf("/"));
                            XmlNodeList newParent = metaNode.SelectNodes(newPath, nsmanager);

                            newParent.Item(0).AppendChild(parentNd);

                            parentNodes = metaNode.SelectNodes(insPath, nsmanager);
                        }


                        XmlReaderSettings xrs = new XmlReaderSettings();
                        xrs.CloseInput = true;

                        TextReader tr = new StringReader(xmlStr);
                        XmlParserContext xpc = new XmlParserContext(null, nsmanager, null, XmlSpace.None);
                        XmlReader xreader = XmlReader.Create(tr, xrs, xpc);
                        
                        XmlNode emptyNode = xdd.ReadNode(xreader);

                        parentNodes.Item(0).AppendChild(emptyNode);

                        currentNodes = metaNode.SelectNodes(xpathStr, nsmanager);
                    }
                    //>>>>>>>>>>>>>>>>>>>>>>>>>>>..

                    if (newSubVal == null)
                    {
                        insertNodesToXml(ref currentNodes, newValue);
                    }
                    /******************sub value************/
                    else
                    {
                        XmlNodeList subNodes = metaNode.SelectNodes(subPath, nsmanager);
                        insertNodesToXml(ref currentNodes, newValue, ref subNodes, newSubVal);
                    }
                    /****************************************/
                    xdd.Save(xmlpath);

                    break;
                }
            }
        }

    }



    //insert specified nodes into xml file
    private void insertNodesToXml(ref XmlNodeList nodelist, string newVal)
    {
        //in this case, the whole content in this node was deleted
        if (nodelist.Count == 1 && nodelist.Item(0).InnerText == "")
        {
            //use the mechnism same as editing, replaceing emtpy field with new value
            XmlNode innerNode = nodelist.Item(0);
            while (innerNode.HasChildNodes)
            {
                innerNode = innerNode.FirstChild;
            }
            innerNode.InnerText = newVal;

            return;

        }

        //pick the single node or the last node in the list
        XmlNode iNode = nodelist.Item(nodelist.Count - 1);

        XmlNode oldChildNode = iNode;

        //in the case the current node is a value node, need to retrieve the whole node (its parents)
        //or find the whole node to contruct this node to be copied and inserted
        if (iNode.Name == "imsmd:value" && iNode.PreviousSibling.Name == "imsmd:source")
        {
            iNode = iNode.ParentNode;
        }
        //in the case: <node1><node2>xxxx<</node2></node1>
        while (iNode.ParentNode.InnerText == iNode.InnerText)
        {
            iNode = iNode.ParentNode;
        }

        //dertermine if inode has been changed ot its parents or not
        if (iNode == oldChildNode)
        {
            XmlNode newNode = iNode.Clone();
            //newNode.InnerText = newValue;  //.this is not working as expected

            XmlNode innerNode = newNode;
            while (innerNode.HasChildNodes)
            {
                innerNode = innerNode.FirstChild;
            }
            innerNode.InnerText = newVal;

            iNode.ParentNode.InsertAfter(newNode, iNode);
        }
        else
        {
            XmlNode newNode = iNode;

            XmlNode newChildNode = oldChildNode.Clone();
            //newChildNode.InnerText = newValue
            XmlNode innerNode = newChildNode;
            while (innerNode.HasChildNodes)
            {
                innerNode = innerNode.FirstChild;
            }
            innerNode.InnerText = newVal;

            //work with newNode = iNode, not clone
            newNode.ReplaceChild(newChildNode, oldChildNode);
            //have to dilibrately change iNode back to before, as it is reference object,
            //its value changed with newNode
            XmlNode newNode2 = newNode.Clone();
            iNode.ReplaceChild(oldChildNode, newChildNode);
            iNode.ParentNode.InsertAfter(newNode2, iNode);


            /*
             *  //work with newNode = iNode.Clone(), but the innerXml attributes won't be removed in this way
            newNode.InnerXml = newNode.InnerXml.Replace(oldChildNode.InnerText, newChildNode.InnerText);
            iNode.ParentNode.InsertAfter(newNode, iNode);
            * */

        }
        

    }


    //insert specified nodes into xml file
    private void insertNodesToXml(ref XmlNodeList nodelist, string newVal, ref XmlNodeList subnodes, string newSubValue)
    {
        //in this case, the whole content in this node was deleted
        if (nodelist.Count == 1 && nodelist.Item(0).InnerText == "")
        {
            //use the mechnism same as editing, replaceing emtpy field with new value
            XmlNode innerNode = nodelist.Item(0);
            while (innerNode.HasChildNodes)
            {
                innerNode = innerNode.FirstChild;
            }
            innerNode.InnerText = newVal;

            /*********sub value**************/
            XmlNode innersubNode = subnodes.Item(0);
            while (innersubNode.HasChildNodes)
            {
                innersubNode = innersubNode.FirstChild;
            }
            innersubNode.InnerText = newSubValue;

            return;

        }

        //pick the single node or the last node in the list
        XmlNode iNode = nodelist.Item(nodelist.Count - 1);
                
        //in the case: <node1><node2>xxxx<</node2></node1>
        while (iNode.ParentNode.InnerText == iNode.InnerText)
        {
            iNode = iNode.ParentNode;
        }
        //for sub node
        XmlNode iSubNode = subnodes.Item(subnodes.Count - 1);
        if (iSubNode.Name == "imsmd:value" && iSubNode.PreviousSibling.Name == "imsmd:source")
        {
            iSubNode = iSubNode.ParentNode;
        }
        while (iSubNode.ParentNode.InnerText == iSubNode.InnerText)
        {
            iSubNode = iSubNode.ParentNode;
        }

        XmlNode NodetoCopy = iNode.ParentNode;  //the highest level of node for to inserted 

        

        //replace the main node in the whole node
        XmlNode newNode = iNode.Clone();
       
        XmlNode innerMainNode = newNode;
        while (innerMainNode.HasChildNodes)
        {
            innerMainNode = innerMainNode.FirstChild;
        }
        innerMainNode.InnerText = newVal;

        NodetoCopy.ReplaceChild(newNode, iNode);
       
        //replace the sub node in the whole node
        XmlNode newSubNode = iSubNode.Clone();

        XmlNode innerSubNode = newSubNode;
        while (innerSubNode.HasChildNodes)
        {
            innerSubNode = innerSubNode.FirstChild;
        }
        innerSubNode.InnerText = newSubValue;

        NodetoCopy.ReplaceChild(newSubNode, iSubNode);

        //insert the new node after the current node
        XmlNode newFinalNode = NodetoCopy.Clone();
        NodetoCopy.ReplaceChild(iNode, newNode);
        NodetoCopy.ReplaceChild(iSubNode, newSubNode);

        NodetoCopy.ParentNode.InsertAfter(newFinalNode, NodetoCopy);   


    }


    protected void BtnComplete_Click(object sender, EventArgs e)
    {
        /* once completing, the modified xml file will be loaded back
         * to the server folder where it was from - prepare for Tool c (content 
         * editing) integration, in tool c case, send an token back to indicate the 
         * editing metadata finished (e.g. "true")
         */ 
        
        /* this version is for testing to connect with Tool C
         * 
        string xmlLocalPath = Server.MapPath(@"App_Data\imsmanifest.xml");

        string fpath = "";
        //sample query string fpath \\dash\wwwroot\metaEditor\metafile\imsmanifest.xml
        //for the upload securtiy reason, don't use http:// format
        if (Request.QueryString["fpath"] != null)
        {
            fpath = Request.QueryString["fpath"].ToString();
        }

        if (fpath.Length == 0)
        {
            LblErrMsg.Text = "The remote file path is not specified";
            LblErrMsg.ForeColor = System.Drawing.Color.Red;
            return;
        }
        
       // fpath = "http://" + fpath;

        System.Net.WebClient remoteClient = new System.Net.WebClient();
        remoteClient.UploadFile(fpath, xmlLocalPath);

        LblErrMsg.Text = "Modified metadata is sent to the server";
        LblErrMsg.ForeColor = System.Drawing.Color.Blue;
        *
        * */

        /* method 2 for exporting content pacakage */
        string currMetaFile = "";
        if (Session["loDir"] == null)
        {
            lblSubmitError.Text = "Cannot find the content package";
            lblSubmitError.ForeColor = System.Drawing.Color.Red;
            return;            
        }
        string currentLoDir = Session["loDir"].ToString();

        currMetaFile = Server.MapPath(@"App_Data") + "\\" + currentLoDir + "\\" + "imsmanifest.xml";
        string newMetaFile = Server.MapPath(@"App_Data") + "\\" + "imsmanifest.xml";

        if (File.Exists(newMetaFile))
        {
            File.Copy(newMetaFile, currMetaFile, true);
        }

        //zip files
        string currPath = Server.MapPath(@"App_Data") + "\\" + currentLoDir;
        
        ZipOutputStream zstream = createZipFile(currPath, currentLoDir, null);
        zstream.Finish();
        zstream.Close();

        //remove the lo directory first
        Directory.Delete(currPath, true);

        //export file
        if (!exportCP(currentLoDir))
        {
            lblSubmitError.Text = "Errors occurred during exporting, please try again";
            lblSubmitError.ForeColor = System.Drawing.Color.Red;
            return; 
        }

        //remove current files from app_data
        //Session.Remove("loDir");
       // removeFiles(currentLoDir);
        
    }


    private bool exportCP(string cpName)
    {
        string cpPath = Server.MapPath(@"App_Data") + "\\" + cpName + ".zip";
        FileInfo zipfile = new FileInfo(cpPath);

        //Clear the current output content from the buffer
        Response.Clear();

        string newName = cpName + ".zip";

        try
        {

            //Add the header that specifies the default filename for the Download/SaveAs dialog
            Response.AddHeader("Content-Disposition", "attachment;filename=" + newName);

            //Add the header that specifies the file size, so that the browser 
            //can show the download progress
            Response.AddHeader("Content-Length", zipfile.Length.ToString());

            //Specify that the response is a stream that cannot be read by the client 
            //and must be downloaded
            Response.ContentType = "application/zip";

            //Send the file stream to the client
            Response.WriteFile(zipfile.FullName);

            //Stop the execution of this page
            Response.End();
            return true;
        }
        catch (Exception e)
        {
            return false;
        }

        
    }



    private ZipOutputStream createZipFile(string zpath, string dirName, ZipOutputStream zipStream)
    {
        string[] filenames = Directory.GetFiles(zpath);


        Crc32 crc = new Crc32();

        //initialize zipStream if it is not set.if should be set only once
        if (zipStream == null)
        {            
            string zfile = Server.MapPath("App_Data")+ "\\" + dirName + ".zip";
           
            zipStream = new ZipOutputStream(File.Create(zfile));

            zipStream.SetLevel(6); // 0 - store only to 9 - means best compression
        }

        foreach (string file in filenames)
        {
            FileStream fs = File.OpenRead(file);

            byte[] buffer = new byte[fs.Length];
            fs.Read(buffer, 0, buffer.Length);
            //important!...to position the subdirectory/files relation,
            //need to remove the root path,just leave relative path
            string lopath = Server.MapPath("App_Data") + "\\" + dirName;
            ZipEntry entry = new ZipEntry(file.Substring(lopath.Length + 1));

            entry.DateTime = DateTime.Now;

            entry.Size = fs.Length;
            fs.Close();

            crc.Reset();
            crc.Update(buffer);

            entry.Crc = crc.Value;

            zipStream.PutNextEntry(entry);

            zipStream.Write(buffer, 0, buffer.Length);

        }
        string[] subdirs = Directory.GetDirectories(zpath);
        foreach (string dir in subdirs)
        {
            createZipFile(dir, dirName, zipStream);
        }

        return zipStream;

    }


    //############ to test add relation
    private void addRelation(string objname, string relationName)
    {
        string xmlpath = Server.MapPath(@"App_Data\imsmanifest.xml");

        // string schema1 = Server.MapPath(@"App_Data\imscp_v1p1.xsd");
        // string schema2 = Server.MapPath(@"App_Data\imsmd_v1p2p4_localised.xsd");

        XmlDataDocument xdd = new XmlDataDocument();

        try
        {
            xdd.Load(xmlpath);
        }
        catch (System.IO.FileNotFoundException e)
        {
            LblErrMsg.Text = "Cannot find the resouce file for metadata";
            LblErrMsg.ForeColor = System.Drawing.Color.Red;
        }

        //look for the namespace for imsmd: it would be under imsmd:lom for reload or other non-elang
        //LOs, but will be defined at root element with localised namspace in eLang LO
        XmlElement root = xdd.DocumentElement;
        string mdPrefix = root.GetNamespaceOfPrefix("imsmd");
        if (mdPrefix.Length == 0)
        {
            XmlNodeList lomNd = root.GetElementsByTagName("imsmd:lom");
            mdPrefix = lomNd[0].GetNamespaceOfPrefix("imsmd");
        }

        XmlNamespaceManager nsmanager = new XmlNamespaceManager(xdd.NameTable);

        /* have to declare a name even it is default namespace no prefix, can not 
         * use String.Empty as recommended somewhere. 
         * see http://msdn2.microsoft.com/en-us/library/d271ytdx.aspx
         * */
        nsmanager.AddNamespace("df", "http://www.imsglobal.org/xsd/imscp_v1p1");
        //nsmanager.AddNamespace("imsmd", "http://www.imsglobal.org/xsd/imsmd_v1p2");
        //to get the namespace dynamically
        nsmanager.AddNamespace("imsmd", mdPrefix);
        nsmanager.AddNamespace("l2o", "imsmd_v1p2_l2o_localised_Schema");

        DataSet metaDs = new DataSet();
        //DataTable loTable = buildLOTable();

        //XmlElement root = xdd.DocumentElement;
        XmlNodeList metadataNodes = xdd.SelectNodes("descendant::df:metadata", nsmanager);

        XmlNode newNode = createNewRelation(objname, relationName, xdd, nsmanager);

        foreach (XmlNode metaNode in metadataNodes)
        {            
           
            if (metaNode.ParentNode.Name == "resource" || metaNode.ParentNode.Name == "manifest" || metadataNodes.Count == 1)
            {
                XmlNodeList classNodes;
                XmlNodeList rightNodes;
                XmlNodeList relationNodes = metaNode.SelectNodes("descendant::imsmd:relation", nsmanager);
                if(relationNodes.Count > 0)
                {
                    XmlNode relaNode = relationNodes[relationNodes.Count-1];
                    relaNode.ParentNode.InsertAfter(newNode,relaNode);

                }
                else if ((classNodes = metaNode.SelectNodes("descendant::imsmd:classification", nsmanager)) != null && classNodes.Count>0)
                {
                    XmlNode classNode = classNodes[0];
                    classNode.ParentNode.InsertBefore(newNode, classNode);
                    
                }
                else if((rightNodes = metaNode.SelectNodes("descendant::imsmd:rights", nsmanager)) != null && rightNodes.Count>0)
                {
                    XmlNode rightNode = rightNodes[rightNodes.Count-1];
                    rightNode.ParentNode.InsertAfter(newNode, rightNode);
                }
                else
                {
                   XmlNodeList lomNodes = metaNode.SelectNodes("descendant::imsmd:lom", nsmanager);
                   lomNodes[0].AppendChild(newNode);
                }

                xdd.Save(xmlpath);
                break;
            }
         }

       
    }


    private XmlNode createNewRelation(string name, string relations, XmlDataDocument xdd, XmlNamespaceManager nsmanager)
    {
        string xmlStr = "<imsmd:relation><imsmd:kind><imsmd:source><imsmd:langstring xml:lang=\"en\">LOMv1.0</imsmd:langstring></imsmd:source><imsmd:value><imsmd:langstring xml:lang=\"x-none\">";
        xmlStr += relations + "</imsmd:langstring></imsmd:value></imsmd:kind><imsmd:resource><imsmd:description><imsmd:langstring xml:lang=\"en\">";
        xmlStr += name + "</imsmd:langstring></imsmd:description></imsmd:resource></imsmd:relation>";

        XmlReaderSettings xrs = new XmlReaderSettings();
        xrs.CloseInput = true;
        TextReader tr = new StringReader(xmlStr);
        XmlParserContext xpc = new XmlParserContext(null, nsmanager, null, XmlSpace.None);
        XmlReader xreader = XmlReader.Create(tr, xrs, xpc);
        
        XmlNode relationNode = xdd.ReadNode(xreader);

        return relationNode;
        
    }
   

}
