<%@ Application Language="C#" %>

<script runat="server">
    
    void Application_Start(object sender, EventArgs e) 
    {
        // Code that runs on application startup

    }
    
    void Application_End(object sender, EventArgs e) 
    {
        //  Code that runs on application shutdown
        string[] files = Session["files"] as string[];

        if (files != null)
        {
            foreach (string ifile in files)
            {
                if (ifile.EndsWith(".xml"))
                {
                    System.IO.File.Delete(ifile);
                }

            }
        }

    }
        
    void Application_Error(object sender, EventArgs e) 
    { 
        // Code that runs when an unhandled error occurs

    }

    void Session_Start(object sender, EventArgs e) 
    {
        // Code that runs when a new session is started
        
        //need to set up files session here at the start of session. otherwise the io.directory.getfiles won't
        //work in the session_end function
        string[] files = System.IO.Directory.GetFiles(Server.MapPath("App_Data"));
        Session["xmlfiles"] = files;
        
        //set download directory to delete
        string[] downloadDirs = System.IO.Directory.GetDirectories(Server.MapPath("download"));
        Session["dldirs"] = downloadDirs;
        
        //set temp dirs
        string[] tempDirs = System.IO.Directory.GetDirectories(Server.MapPath(@"App_Data\temp\"));
        Session["tempdirs"] = tempDirs;

    }

    void Session_End(object sender, EventArgs e) 
    {
        // Code that runs when a session ends. 
        // Note: The Session_End event is raised only when the sessionstate mode
        // is set to InProc in the Web.config file. If session mode is set to StateServer 
        // or SQLServer, the event is not raised.
        
        //may need to delete based on user id
       // string[] files = System.IO.Directory.GetFiles(Server.MapPath("App_Data"));
        string[] files = Session["xmlfiles"] as string[];

        if (files != null)
        {

            foreach (string ifile in files)
            {
                if (ifile.EndsWith(".xml"))
                {
                    System.IO.File.Delete(ifile);
                }

            }
        }
        
        //remove existing download folders
        string[] dlDirs = Session["dldirs"] as string[];
        if (dlDirs != null && dlDirs.Length > 0)
        {
            foreach (string dld in dlDirs)
            {
                System.IO.Directory.Delete(dld, true);
            }
        }

        //remove existing temp folders
        string[] tmpDirs = Session["tempdirs"] as string[];
        if (tmpDirs != null && tmpDirs.Length > 0)
        {
            foreach (string tdir in tmpDirs)
            {
                System.IO.Directory.Delete(tdir, true);
            }
        }

    }
       
</script>
