using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.IO;

public partial class download : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
              
        Session["isComplete"] = null;

        string pPath = "";
        if (Request.QueryString["dir"] != null)
        {
            pPath = Request.QueryString["dir"];
        }
        string pName = "";
        if (Request.QueryString["name"] != null)
        {
            pName = Request.QueryString["name"];
        }

        pName = pName + ".zip";
        string filepath = Server.MapPath(@"download\") + pPath + "\\";
        FileInfo zipfile = new FileInfo(filepath + pName);

        //Clear the current output content from the buffer
        Response.Clear();

        

        try
        {

            //Add the header that specifies the default filename for the Download/SaveAs dialog
            Response.AddHeader("Content-Disposition", "attachment;filename=" + pName);

            //Add the header that specifies the file size, so that the browser 
            //can show the download progress
            Response.AddHeader("Content-Length", zipfile.Length.ToString());

            //Specify that the response is a stream that cannot be read by the client 
            //and must be downloaded
            Response.ContentType = "application/zip";

            //Send the file stream to the client
            Response.WriteFile(zipfile.FullName);

            //Stop the execution of this page
            //Response.End();
            Response.Flush();
            Response.Close();

            Session["isComplete"] = true;

            if (Directory.Exists(filepath))
            {
                Directory.Delete(filepath, true);
            }

           

        }
        catch (Exception ex)
        {
            Response.Write(ex.Message);
        }

    }
   
}
