using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Xml;
using System.IO;


/// <summary>
/// To do: progress bar (?), configuration setting in webconfig for xpath
/// userid as ipaddress; Pager setting up
/// </summary>
public partial class searchbak : System.Web.UI.Page 
{
    //string eprintBaseUrl = "http://elektra.ecs.soton.ac.uk:8080/";

    protected void Page_Load(object sender, EventArgs e)
    {
        LblErrMsg.Text = "";

        if (!IsPostBack)
        {
            if (Session["cart"] == null)
            {
            }
            else
            {
            }
        }

        string sq = "";
        if (Request.QueryString["sq"] != null)
        {
            sq = Request.QueryString["sq"];
        }
        //!!! test this sq = Request.QueryString["sq"] as string;
        
        //string type = Ep  //set an enum structure

        executeSearch(sq);

        
    }


    private void executeSearch(string queries)
    {
    }


    private LoDset buildDataSource()
    {
        string xmlfilepath = Server.MapPath(@"App_Data\original.xml");

        LoDset ds = new LoDset(); //might need to be public

        //ds.ReadXml(path1);
        //ds.LoProducts[0].title;

        XmlDataDocument xdd = new XmlDataDocument();

        try
        {
            xdd.Load(xmlfilepath);
        }
        catch (System.IO.FileNotFoundException ex)
        {
            LblErrMsg.Text = ex.Message + ":Can not find the resouce file for metadata";
            LblErrMsg.ForeColor = System.Drawing.Color.Red;
            return null;
        }

        XmlNamespaceManager nsmanager = new XmlNamespaceManager(xdd.NameTable);
        nsmanager.AddNamespace("ns1", "http://eprints.org/ep2/data/2.0");

        XmlElement root = xdd.DocumentElement;
        XmlNodeList loList = root.SelectNodes("descendant::ns1:eprint", nsmanager);

        for (int i = 0; i < loList.Count; i++)
        {
            LoDset.LoProductsRow nRow = ds.LoProducts.NewLoProductsRow();
            nRow.reposId = getMetaValues(loList.Item(i), "child::ns1:eprintid", null, nsmanager);
            string[] subpaths = new string[] { "child::ns1:given", "child::ns1:family" };
            nRow.authors = getMetaValues(loList.Item(i), "child::ns1:creators/descendant::ns1:name", subpaths, nsmanager);
            nRow.title = getMetaValues(loList.Item(i), "child::ns1:title", null, nsmanager);
            nRow.description = getMetaValues(loList.Item(i), "child::ns1:description", null, nsmanager);

            ds.LoProducts.AddLoProductsRow(nRow);

        }


        return ds;
        
    }


    private string getMetaValues(XmlNode oneLO, string xpath, string[] subXpaths, XmlNamespaceManager nsm)
    {
        XmlNodeList metas = oneLO.SelectNodes(xpath, nsm);
        //In theory, only authors has more than one value, i do this just to cover the possilbe future changes
        string metaValue = "";
        
        if (metas.Count > 1)
        {
            for (int i = 0; i < metas.Count; i++)
            {
                if (subXpaths == null)
                {
                    metaValue += metas.Item(i).InnerText + ", ";
                }
                else
                {
                    string tempValue = "";
                    string subValue = "";
                    if (subXpaths.Length == 2 && (tempValue = metas.Item(i).SelectNodes(subXpaths[0], nsm).Item(0).InnerText) == metas.Item(i).SelectNodes(subXpaths[1], nsm).Item(0).InnerText)
                    {
                        subValue = tempValue;
                    }
                    else
                    {
                        for (int j = 0; j < subXpaths.Length; j++)
                        {
                            subValue += metas.Item(i).SelectNodes(subXpaths[j], nsm).Item(0).InnerText + " ";
                        }
                        subValue = subValue.Substring(0, subValue.Length - 1); //remove the last space
                    }
                    metaValue += subValue + ", ";
                }
            }
            //remove the last ", "
            metaValue = metaValue.Substring(0, metaValue.Length - 2);

        }
        else if (metas.Count == 1)
        {
            if (subXpaths == null)
            {
                metaValue = metas.Item(0).InnerText;
            }
            else
            {
                string tempValue = "";
                //this is for the specila case when given name and family name are the same  (not good)
                if (subXpaths.Length == 2 && (tempValue = metas.Item(0).SelectNodes(subXpaths[0], nsm).Item(0).InnerText) == metas.Item(0).SelectNodes(subXpaths[1], nsm).Item(0).InnerText)
                {
                    metaValue = tempValue;
                }
                else
                {
                    for (int j = 0; j < subXpaths.Length; j++)
                    {
                        metaValue += metas.Item(0).SelectNodes(subXpaths[j], nsm).Item(0).InnerText + " ";

                    }
                    metaValue = metaValue.Substring(0, metaValue.Length - 1); //remove the last space
                }
               
            }
        }

        return metaValue;
    }


    protected void BtnSearch_Click(object sender, EventArgs e)
    {
        LoDset curSet = Session["cart"] as LoDset;

        if (curSet == null)
        {
            curSet = buildDataSource();
            Session["cart"] = curSet;
        }

        DataListSearch.DataSource = curSet.LoProducts;
        DataListSearch.DataBind();

        GridView1.DataSource = curSet.LoProducts;
        GridView1.DataBind();
    }



    protected void DataListSearch_ItemCommand(object source, DataListCommandEventArgs e)
    {
        if (e.CommandName == "addToCart")
        {
            /*
            string pid = DataListSearch.DataKeys[e.Item.ItemIndex].ToString();

            string itemUrl = eprintBaseUrl + pid + "//";

            Response.Redirect(itemUrl);
           */

            string pid = DataListSearch.DataKeys[e.Item.ItemIndex].ToString();

            LoDset curSet = getShoppingCartDataSet();

            //check if exising rows with the same product Id
            DataRow[] existingRows = curSet.LoOrders.Select("productId=" + pid);
            if (existingRows.Length > 0)
            {
                LblErrMsg.Text = "The current learning object is already in the shopping cart!";
                LblErrMsg.ForeColor = System.Drawing.Color.DarkBlue;
                return;
            }

            //decide if the same user working on the shopping trolley or not
            int numofRows = curSet.LoOrders.Rows.Count;
            string prevUser = curSet.LoOrders.Rows[numofRows - 1]["userId"].ToString();
            if (!Request.UserHostAddress.Equals(prevUser))
            {
                LblErrMsg.Text = "Please clear the Cart first!";
                LblErrMsg.ForeColor = System.Drawing.Color.DarkBlue;
                return;
            }


            LoDset.LoOrdersRow newOrder = curSet.LoOrders.NewLoOrdersRow();

            //the current product being selected and to be added
            LoDset.LoProductsRow curProductRow = curSet.LoProducts.FindByproductId(Convert.ToInt32(pid));

            newOrder.productId = curProductRow.productId;
            newOrder.userId = Request.UserHostAddress;
            newOrder.reposId = curProductRow.reposId;
            newOrder.title = curProductRow.title;
            newOrder.authors = curProductRow.authors;
            newOrder.description = curProductRow.description;
            newOrder.reposType = curProductRow.reposType;
           

            curSet.LoOrders.AddLoOrdersRow(newOrder);

            Session["cart"] = curSet;  //update cart session

            GridView1.DataSource = curSet.LoOrders;
            GridView1.DataBind();
            
        }
    }



    private LoDset getShoppingCartDataSet()
    {
        LoDset cartSet = Session["cart"] as LoDset;

        if (cartSet == null)
        {
            cartSet = buildDataSource();
            Session["cart"] = cartSet;
        }

        return cartSet;


    }


    
}
