using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class trolley : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            bindGrid();


        }

    }


   /* Not to be fired now - the solution below is recommended which might be better for the firing twice case
    * */
    protected void GridViewCart_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        if (Session["cart"] != null)
        {
            LoDset.LoOrdersDataTable curSets = Session["cart"] as LoDset.LoOrdersDataTable;
            //to find the primary key orderid by index, as index doesn't equal to orderid after deletions
           
            // "!!! need to use datakeys otherwise the e.rowindex will increment and delete the next
            // row as well in IE (!!!). In IE, this function is run twice (at least) on one click??
            // 
            // int orderId = Convert.ToInt32(curSets.Rows[e.RowIndex]["orderId"]);
            int orderId = Convert.ToInt32(GridViewCart.DataKeys[e.RowIndex].Value);
            
            LoDset.LoOrdersRow rowtoDelete = curSets.FindByorderId(orderId);

            if (rowtoDelete != null)   //necessary for IE
            {
                curSets.RemoveLoOrdersRow(rowtoDelete);
            }

            Session["cart"] = curSets;

            bindGrid();
            

        }
    }

    /* use this funtion to replace the above auto-generated rowdeleting command, whch has a known bug
     * of firing twice with the presensce of image button. in order to use this, turn button field to
     * template field first
     * */
    protected void OnRemoveItem(object sender, CommandEventArgs e)
    {
        if (e.CommandName.Equals("bDelete"))
        {

            if (Session["cart"] != null)
            {
                LoDset.LoOrdersDataTable curSets = Session["cart"] as LoDset.LoOrdersDataTable;

                int orderId = Convert.ToInt32(e.CommandArgument.ToString());

                LoDset.LoOrdersRow rowtoDelete = curSets.FindByorderId(orderId);

                if (rowtoDelete != null)   //necessary for IE
                {
                    curSets.RemoveLoOrdersRow(rowtoDelete);
                }

                Session["cart"] = curSets;

                bindGrid();

            }
            else
            {
                GridViewCart.DataSource = null;
                GridViewCart.DataBind();

                LblMsg.Text = "Cannot execute removing, because the trolley has been emptied!";
            }

        }
    }


    protected void GridViewCart_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        //arrange index at runtime, otherwise the orderid might appear to be uncontinuous after deleting
        if (e.Row.RowType == DataControlRowType.DataRow)
        {
            Label lblIdx = (Label)e.Row.FindControl("lblIndex");
            lblIdx.Text = Convert.ToString(e.Row.RowIndex + 1);

        }
    }


    protected void BtnClear_Click(object sender, ImageClickEventArgs e)
    {

        if (Session["cart"] != null)
        {
            LoDset.LoOrdersDataTable curSets = Session["cart"] as LoDset.LoOrdersDataTable;
            curSets.Clear();

            Session["cart"] = null;

            bindGrid();
            
        }

    }

    private void bindGrid()
    {
        LoDset.LoOrdersDataTable curSets = Session["cart"] as LoDset.LoOrdersDataTable;
        
        GridViewCart.DataSource = curSets;
        GridViewCart.DataBind();

        if (curSets == null || curSets.Rows.Count == 0)
        {
            LblMsg.Text = "Your Trolley is Empty!";
            BtnClear.Visible = false;
            HLcheckout.Visible = false;
        }
        

    }


}
